/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.logger.internal;

import com.speedment.common.logger.Level;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerEventListener;
import com.speedment.common.logger.LoggerFactory;
import com.speedment.common.logger.LoggerFormatter;
import com.speedment.common.logger.internal.formatter.StandardFormatters;
import com.speedment.common.logger.internal.util.NullUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;

public abstract class AbstractLoggerFactory
implements LoggerFactory {
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private final Set<LoggerEventListener> listeners;
    private LoggerFormatter formatter = StandardFormatters.PLAIN_FORMATTER;

    AbstractLoggerFactory() {
        this.listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    public Logger create(Class<?> binding) {
        Objects.requireNonNull(binding);
        return this.acquireLogger(this.makeNameFrom(binding));
    }

    protected String makeNameFrom(Class<?> binding) {
        Objects.requireNonNull(binding);
        String[] tokens = binding.getName().split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i == tokens.length - 1) {
                sb.append(tokens[i]);
                continue;
            }
            sb.append(tokens[i].charAt(0)).append('.');
        }
        return sb.toString();
    }

    @Override
    public Logger create(String binding) {
        Objects.requireNonNull(binding);
        return this.acquireLogger(binding);
    }

    @Override
    public synchronized void setFormatter(LoggerFormatter formatter) {
        this.formatter = Objects.requireNonNull(formatter);
        this.forEachLogger(l -> l.setFormatter(formatter));
    }

    @Override
    public synchronized LoggerFormatter getFormatter() {
        return this.formatter;
    }

    protected Logger acquireLogger(String binding) {
        Objects.requireNonNull(binding);
        return this.loggers.computeIfAbsent(binding, b -> {
            Logger log = this.make((String)b, this.formatter);
            this.listeners.forEach(log::addListener);
            return log;
        });
    }

    public abstract Logger make(String var1, LoggerFormatter var2);

    @Override
    public void addListener(LoggerEventListener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.add(listener)) {
            this.forEachLogger(l -> l.addListener(listener));
        }
    }

    @Override
    public void removeListener(LoggerEventListener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.remove(listener)) {
            this.forEachLogger(l -> l.removeListener(listener));
        }
    }

    private void forEachLogger(Consumer<Logger> consumer) {
        Objects.requireNonNull(consumer);
        this.loggers().map(Map.Entry::getValue).forEach(consumer);
    }

    @Override
    public Stream<LoggerEventListener> listeners() {
        return this.listeners.stream();
    }

    @Override
    public Stream<Map.Entry<String, Logger>> loggers() {
        return this.loggers.entrySet().stream();
    }

    @Override
    public void setLevel(String path, Level level) {
        NullUtil.requireNonNulls(path, level);
        this.loggers().filter(e -> ((String)e.getKey()).startsWith(path)).map(Map.Entry::getValue).forEach(l -> l.setLevel(level));
    }

    @Override
    public void setLevel(Class<?> binding, Level level) {
        NullUtil.requireNonNulls(binding, level);
        this.setLevel(this.makeNameFrom(binding), level);
    }
}

