/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.logger.internal.formatter;

import com.speedment.common.logger.Level;
import com.speedment.common.logger.LoggerFormatter;
import java.time.Instant;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class PlainFormatter
implements LoggerFormatter {
    private static final String INSTANT_STAMPLE = Instant.ofEpochSecond(0L, 1000000L).toString();
    private static final int DECIMALS = PlainFormatter.decimals();
    private static String PADDING_REF = "." + IntStream.range(0, DECIMALS).mapToObj(i -> "0").collect(Collectors.joining());
    private static final int INSTANT_LENGTH = INSTANT_STAMPLE.length();

    @Override
    public String apply(Level level, String name, String message) {
        Objects.requireNonNull(level);
        Objects.requireNonNull(name);
        return this.formatInstance(Instant.now().toString()) + " " + level.toText() + " [" + Thread.currentThread().getName() + "] (" + name + ") - " + message;
    }

    protected String formatInstance(String instantString) {
        if (instantString.length() >= INSTANT_LENGTH) {
            return instantString;
        }
        int missingCharacters = INSTANT_LENGTH - instantString.length();
        if (missingCharacters > PADDING_REF.length()) {
            return instantString;
        }
        String padding = PADDING_REF.substring(PADDING_REF.length() - missingCharacters);
        return instantString.substring(0, instantString.length() - 1) + padding + "Z";
    }

    private static int decimals() {
        int indexOfDot = INSTANT_STAMPLE.lastIndexOf(".");
        int indexOfZ = INSTANT_STAMPLE.lastIndexOf("Z");
        if (indexOfDot > 0 && indexOfZ > 0) {
            int decimals = indexOfZ - indexOfDot - 1;
            return decimals;
        }
        return 6;
    }
}

