/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config;

import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.exception.SpeedmentConfigException;
import com.speedment.runtime.config.mutator.DbmsMutator;
import com.speedment.runtime.config.mutator.DocumentMutator;
import com.speedment.runtime.config.trait.HasAlias;
import com.speedment.runtime.config.trait.HasChildren;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.runtime.config.trait.HasId;
import com.speedment.runtime.config.trait.HasMainInterface;
import com.speedment.runtime.config.trait.HasMutator;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.trait.HasParent;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;

public interface Dbms
extends Document,
HasParent<Project>,
HasEnabled,
HasId,
HasName,
HasChildren,
HasAlias,
HasMainInterface,
HasMutator<DbmsMutator<? extends Dbms>> {
    public static final String TYPE_NAME = "typeName";
    public static final String IP_ADDRESS = "ipAddress";
    public static final String PORT = "port";
    public static final String CONNECTION_URL = "connectionUrl";
    public static final String USERNAME = "username";
    public static final String SCHEMAS = "schemas";

    default public String getTypeName() {
        return this.getAsString(TYPE_NAME).orElseThrow(() -> new SpeedmentConfigException("Every " + Dbms.class.getSimpleName() + " document is required to have the '" + TYPE_NAME + "' attribute."));
    }

    default public Optional<String> getIpAddress() {
        return this.getAsString(IP_ADDRESS);
    }

    default public OptionalInt getPort() {
        return this.getAsInt(PORT);
    }

    default public Optional<String> getConnectionUrl() {
        return this.getAsString(CONNECTION_URL);
    }

    default public Optional<String> getUsername() {
        return this.getAsString(USERNAME);
    }

    public Stream<? extends Schema> schemas();

    default public Class<Dbms> mainInterface() {
        return Dbms.class;
    }

    @Override
    default public DbmsMutator<? extends Dbms> mutator() {
        return DocumentMutator.of(this);
    }
}

