/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config;

import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.mutator.DocumentMutator;
import com.speedment.runtime.config.mutator.ForeignKeyColumnMutator;
import com.speedment.runtime.config.trait.HasColumn;
import com.speedment.runtime.config.trait.HasId;
import com.speedment.runtime.config.trait.HasMainInterface;
import com.speedment.runtime.config.trait.HasMutator;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.trait.HasOrdinalPosition;
import com.speedment.runtime.config.trait.HasParent;
import com.speedment.runtime.config.util.DocumentUtil;
import java.util.Optional;

public interface ForeignKeyColumn
extends Document,
HasParent<ForeignKey>,
HasId,
HasName,
HasOrdinalPosition,
HasColumn,
HasMainInterface,
HasMutator<ForeignKeyColumnMutator<? extends ForeignKeyColumn>> {
    public static final String FOREIGN_TABLE_NAME = "foreignTableName";
    public static final String FOREIGN_COLUMN_NAME = "foreignColumnName";
    public static final String FOREIGN_DATABASE_NAME = "foreignDatabaseName";
    public static final String FOREIGN_SCHEMA_NAME = "foreignSchemaName";

    default public String getForeignDatabaseName() {
        return this.getAsString(FOREIGN_DATABASE_NAME).orElseThrow(DocumentUtil.newNoSuchElementExceptionFor(this, FOREIGN_DATABASE_NAME));
    }

    default public String getForeignSchemaName() {
        return this.getAsString(FOREIGN_SCHEMA_NAME).orElseThrow(DocumentUtil.newNoSuchElementExceptionFor(this, FOREIGN_SCHEMA_NAME));
    }

    default public String getForeignTableName() {
        return this.getAsString(FOREIGN_TABLE_NAME).orElseThrow(DocumentUtil.newNoSuchElementExceptionFor(this, FOREIGN_TABLE_NAME));
    }

    default public String getForeignColumnName() {
        return this.getAsString(FOREIGN_COLUMN_NAME).orElseThrow(DocumentUtil.newNoSuchElementExceptionFor(this, FOREIGN_COLUMN_NAME));
    }

    default public Optional<? extends Table> findForeignTable() {
        Optional<Schema> schema = this.ancestors().filter(Schema.class::isInstance).map(Schema.class::cast).findFirst();
        return schema.flatMap(s -> s.tables().filter(tab -> tab.getId().equals(this.getForeignTableName())).findAny());
    }

    default public Optional<? extends Column> findForeignColumn() {
        return this.findForeignTable().flatMap(table -> table.columns().filter(col -> col.getId().equals(this.getForeignColumnName())).findAny());
    }

    default public Class<ForeignKeyColumn> mainInterface() {
        return ForeignKeyColumn.class;
    }

    @Override
    default public ForeignKeyColumnMutator<? extends ForeignKeyColumn> mutator() {
        return DocumentMutator.of(this);
    }
}

