/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config;

import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.exception.SpeedmentConfigException;
import com.speedment.runtime.config.internal.ProjectImpl;
import com.speedment.runtime.config.mutator.DocumentMutator;
import com.speedment.runtime.config.mutator.ProjectMutator;
import com.speedment.runtime.config.trait.HasChildren;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.runtime.config.trait.HasId;
import com.speedment.runtime.config.trait.HasMainInterface;
import com.speedment.runtime.config.trait.HasMutator;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.trait.HasPackageName;
import com.speedment.runtime.config.util.DocumentUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public interface Project
extends Document,
HasEnabled,
HasId,
HasName,
HasPackageName,
HasChildren,
HasMainInterface,
HasMutator<ProjectMutator<? extends Project>> {
    public static final String COMPANY_NAME = "companyName";
    public static final String PACKAGE_LOCATION = "packageLocation";
    public static final String SPEEDMENT_VERSION = "speedmentVersion";
    public static final String CONFIG_PATH = "configPath";
    public static final String DBMSES = "dbmses";
    public static final String APP_ID = "appId";
    public static final String DEFAULT_COMPANY_NAME = "company";
    public static final String DEFAULT_PACKAGE_NAME = "com.";
    public static final String DEFAULT_PACKAGE_LOCATION = "src/main/java/";
    public static final String DEFAULT_PROJECT_NAME = Project.class.getSimpleName();
    public static final Pattern SPLIT_PATTERN = Pattern.compile("\\.");

    public static Project deepCopy(Project existing) {
        return DocumentUtil.deepCopy(existing, ProjectImpl::new);
    }

    default public String getCompanyName() {
        return this.getAsString(COMPANY_NAME).orElse(DEFAULT_COMPANY_NAME);
    }

    default public String getPackageLocation() {
        return this.getAsString(PACKAGE_LOCATION).orElse(DEFAULT_PACKAGE_LOCATION);
    }

    default public Optional<String> getSpeedmentVersion() {
        return this.getAsString(SPEEDMENT_VERSION);
    }

    default public String getAppId() {
        return this.getAsString(APP_ID).orElseThrow(() -> new SpeedmentConfigException("All applications must have an 'appId' property."));
    }

    default public Optional<Path> getConfigPath() {
        return this.getAsString(CONFIG_PATH).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public Stream<? extends Dbms> dbmses();

    default public Class<Project> mainInterface() {
        return Project.class;
    }

    @Override
    default public ProjectMutator<? extends Project> mutator() {
        return DocumentMutator.of(this);
    }

    default public Table findTableByName(String fullName) {
        String[] parts = SPLIT_PATTERN.split(fullName);
        if (parts.length != 3) {
            throw new IllegalArgumentException("fullName should consist of three parts separated by dots. These are dbms-name, schema-name and table-name.");
        }
        String dbmsId = parts[0];
        String schemaId = parts[1];
        String tableId = parts[2];
        return this.dbmses().filter(d -> dbmsId.equals(d.getId())).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find dbms: '" + dbmsId + "'.")).schemas().filter(s -> schemaId.equals(s.getId())).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find schema: '" + schemaId + "'.")).tables().filter(t -> tableId.equals(t.getId())).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find table: '" + tableId + "'."));
    }
}

