/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config;

import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.Index;
import com.speedment.runtime.config.PrimaryKeyColumn;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.mutator.DocumentMutator;
import com.speedment.runtime.config.mutator.TableMutator;
import com.speedment.runtime.config.trait.HasAlias;
import com.speedment.runtime.config.trait.HasChildren;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.runtime.config.trait.HasId;
import com.speedment.runtime.config.trait.HasMainInterface;
import com.speedment.runtime.config.trait.HasMutator;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.trait.HasPackageName;
import com.speedment.runtime.config.trait.HasParent;
import java.util.Optional;
import java.util.stream.Stream;

public interface Table
extends Document,
HasParent<Schema>,
HasEnabled,
HasId,
HasName,
HasChildren,
HasAlias,
HasPackageName,
HasMainInterface,
HasMutator<TableMutator<? extends Table>> {
    public static final String COLUMNS = "columns";
    public static final String INDEXES = "indexes";
    public static final String FOREIGN_KEYS = "foreignKeys";
    public static final String PRIMARY_KEY_COLUMNS = "primaryKeyColumns";
    public static final String IS_VIEW = "isView";

    default public boolean isView() {
        return this.getAsBoolean(IS_VIEW).orElse(false);
    }

    public Stream<? extends Column> columns();

    public Stream<? extends Index> indexes();

    public Stream<? extends ForeignKey> foreignKeys();

    public Stream<? extends PrimaryKeyColumn> primaryKeyColumns();

    default public Optional<? extends Column> findColumn(String id) {
        return this.columns().filter(child -> child.getId().equals(id)).findAny();
    }

    default public Optional<? extends Index> findIndex(String id) {
        return this.indexes().filter(child -> child.getId().equals(id)).findAny();
    }

    default public Optional<? extends ForeignKey> findForeignKey(String id) {
        return this.foreignKeys().filter(child -> child.getId().equals(id)).findAny();
    }

    default public Optional<? extends PrimaryKeyColumn> findPrimaryKeyColumn(String id) {
        return this.primaryKeyColumns().filter(child -> child.getId().equals(id)).findAny();
    }

    default public Class<Table> mainInterface() {
        return Table.class;
    }

    @Override
    default public TableMutator<? extends Table> mutator() {
        return DocumentMutator.of(this);
    }
}

