/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.identifier;

import com.speedment.runtime.config.identifier.ColumnLabel;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.config.identifier.trait.HasColumnName;
import com.speedment.runtime.config.identifier.trait.HasDbmsName;
import com.speedment.runtime.config.identifier.trait.HasSchemaName;
import com.speedment.runtime.config.identifier.trait.HasTableName;
import com.speedment.runtime.config.internal.identifier.ColumnIdentifierImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface ColumnIdentifier<ENTITY>
extends HasDbmsName,
HasSchemaName,
HasTableName,
HasColumnName {
    public static <ENTITY> ColumnIdentifier<ENTITY> of(String dbmsName, String schemaName, String tableName, String columnName) {
        ColumnIdentifierImpl newId = new ColumnIdentifierImpl(dbmsName, schemaName, tableName, columnName);
        Hidden.INTERNED.putIfAbsent(newId, newId);
        ColumnIdentifier result = (ColumnIdentifier)Hidden.INTERNED.get(newId);
        return result;
    }

    default public TableIdentifier<ENTITY> asTableIdentifier() {
        return TableIdentifier.of(this.getDbmsName(), this.getSchemaName(), this.getTableName());
    }

    default public ColumnLabel label() {
        return ColumnLabel.of(this);
    }

    public static class Hidden {
        private static final Map<ColumnIdentifier<?>, ColumnIdentifier<?>> INTERNED = new ConcurrentHashMap();
    }
}

