/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.identifier;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.config.identifier.SchemaIdentifier;
import com.speedment.runtime.config.identifier.trait.HasDbmsName;
import com.speedment.runtime.config.identifier.trait.HasSchemaName;
import com.speedment.runtime.config.identifier.trait.HasTableName;
import com.speedment.runtime.config.internal.identifier.TableIdentifierImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface TableIdentifier<ENTITY>
extends HasDbmsName,
HasSchemaName,
HasTableName {
    default public SchemaIdentifier<ENTITY> asSchemaIdentifier() {
        return SchemaIdentifier.of(this.getDbmsName(), this.getSchemaName());
    }

    default public ColumnIdentifier<ENTITY> asColumnIdentifier(String columnName) {
        return ColumnIdentifier.of(this.getDbmsName(), this.getSchemaName(), this.getTableName(), columnName);
    }

    public static <ENTITY> TableIdentifier<ENTITY> of(String dbmsName, String schemaName, String tableName) {
        TableIdentifierImpl newId = new TableIdentifierImpl(dbmsName, schemaName, tableName);
        Hidden.INTERNED.putIfAbsent(newId, newId);
        TableIdentifier result = (TableIdentifier)Hidden.INTERNED.get(newId);
        return result;
    }

    public static class Hidden {
        private static final Map<TableIdentifier<?>, TableIdentifier<?>> INTERNED = new ConcurrentHashMap();
    }
}

