/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal;

import com.speedment.common.function.OptionalBoolean;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.util.DocumentUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Stream;

public class BaseDocument
implements Document {
    private final transient Document parent;
    private final Map<String, Object> config;

    public BaseDocument(Document parent, Map<String, Object> data) {
        this.parent = parent;
        this.config = Objects.requireNonNull(data);
    }

    @Override
    public Optional<? extends Document> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Map<String, Object> getData() {
        return this.config;
    }

    @Override
    public Optional<Object> get(String key) {
        return Optional.ofNullable(this.config.get(key));
    }

    @Override
    public OptionalBoolean getAsBoolean(String key) {
        return OptionalBoolean.ofNullable((Boolean)((Boolean)this.config.get(key)));
    }

    @Override
    public OptionalLong getAsLong(String key) {
        Number value = (Number)this.config.get(key);
        return value == null ? OptionalLong.empty() : OptionalLong.of(value.longValue());
    }

    @Override
    public OptionalDouble getAsDouble(String key) {
        Number value = (Number)this.config.get(key);
        return value == null ? OptionalDouble.empty() : OptionalDouble.of(value.doubleValue());
    }

    @Override
    public OptionalInt getAsInt(String key) {
        Number value = (Number)this.config.get(key);
        return value == null ? OptionalInt.empty() : OptionalInt.of(value.intValue());
    }

    @Override
    public Optional<String> getAsString(String key) {
        return this.get(key).map(String.class::cast);
    }

    @Override
    public void put(String key, Object value) {
        Objects.requireNonNull(value);
        this.config.put(key, value);
    }

    public Stream<Document> children() {
        return DocumentUtil.childrenOf(this, BaseDocument::new);
    }
}

