/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.identifier;

import com.speedment.runtime.config.identifier.TableIdentifier;
import java.util.Objects;

public final class TableIdentifierImpl<ENTITY>
implements TableIdentifier<ENTITY> {
    private final String dbmsName;
    private final String schemaName;
    private final String tableName;
    private final int hashCode;

    public TableIdentifierImpl(String dbmsName, String schemaName, String tableName) {
        this.dbmsName = Objects.requireNonNull(dbmsName);
        this.schemaName = Objects.requireNonNull(schemaName);
        this.tableName = Objects.requireNonNull(tableName);
        this.hashCode = this.privateHashCode();
    }

    @Override
    public String getDbmsName() {
        return this.dbmsName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TableIdentifier) {
            TableIdentifier that = (TableIdentifier)obj;
            return Objects.equals(this.dbmsName, that.getDbmsName()) && Objects.equals(this.schemaName, that.getSchemaName()) && Objects.equals(this.tableName, that.getTableName());
        }
        return false;
    }

    private int privateHashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.dbmsName);
        hash = 53 * hash + Objects.hashCode(this.schemaName);
        hash = 53 * hash + Objects.hashCode(this.tableName);
        return hash;
    }

    public String toString() {
        return this.dbmsName + "." + this.schemaName + "." + this.tableName;
    }
}

