/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.immutable;

import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.internal.ColumnImpl;
import com.speedment.runtime.config.internal.immutable.ImmutableDocument;
import com.speedment.runtime.config.internal.immutable.ImmutableTable;
import com.speedment.runtime.config.trait.HasNullable;
import com.speedment.runtime.config.util.DocumentUtil;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public final class ImmutableColumn
extends ImmutableDocument
implements Column {
    private final transient boolean enabled;
    private final transient String id;
    private final transient String name;
    private final transient Optional<String> alias;
    private final transient boolean nullable;
    private final transient int ordinalPosition;
    private final transient HasNullable.ImplementAs nullableImplementation;
    private final transient boolean autoincrement;
    private final transient Optional<String> typeMapper;
    private final transient String databaseType;
    private final transient Class<?> databaseTypeObject;
    private final transient Optional<String> enumConstants;
    private final transient OptionalInt decimalDigits;
    private final transient OptionalInt columnSize;

    ImmutableColumn(ImmutableTable parent, Map<String, Object> data) {
        super(parent, data);
        ColumnImpl prototype = new ColumnImpl(parent, data);
        this.enabled = prototype.isEnabled();
        this.id = prototype.getId();
        this.name = prototype.getName();
        this.alias = prototype.getAlias();
        this.nullable = prototype.isNullable();
        this.nullableImplementation = prototype.getNullableImplementation();
        this.autoincrement = prototype.isAutoIncrement();
        this.typeMapper = prototype.getTypeMapper();
        this.databaseType = prototype.getDatabaseType();
        this.databaseTypeObject = prototype.findDatabaseType();
        this.enumConstants = prototype.getEnumConstants();
        this.decimalDigits = prototype.getDecimalDigits();
        this.columnSize = prototype.getColumnSize();
        this.ordinalPosition = prototype.getOrdinalPosition();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getAlias() {
        return this.alias;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public HasNullable.ImplementAs getNullableImplementation() {
        return this.nullableImplementation;
    }

    @Override
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.autoincrement;
    }

    @Override
    public Optional<String> getTypeMapper() {
        return this.typeMapper;
    }

    @Override
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public Class<?> findDatabaseType() {
        return this.databaseTypeObject;
    }

    @Override
    public Optional<String> getEnumConstants() {
        return this.enumConstants;
    }

    @Override
    public OptionalInt getDecimalDigits() {
        return this.decimalDigits;
    }

    @Override
    public OptionalInt getColumnSize() {
        return this.columnSize;
    }

    @Override
    public Optional<Table> getParent() {
        return super.getParent().map(Table.class::cast);
    }

    @Override
    public String toString() {
        return DocumentUtil.toStringHelper(this);
    }
}

