/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.immutable;

import com.speedment.common.invariant.NullUtil;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.internal.DbmsImpl;
import com.speedment.runtime.config.internal.immutable.ImmutableDocument;
import com.speedment.runtime.config.internal.immutable.ImmutableProject;
import com.speedment.runtime.config.internal.immutable.ImmutableSchema;
import com.speedment.runtime.config.util.DocumentUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ImmutableDbms
extends ImmutableDocument
implements Dbms {
    private final transient boolean enabled;
    private final transient String id;
    private final transient String name;
    private final transient Optional<String> alias;
    private final transient String typeName;
    private final transient Optional<String> ipAddress;
    private final transient OptionalInt port;
    private final transient Optional<String> username;
    private final transient List<ImmutableSchema> schemas;

    ImmutableDbms(ImmutableProject parent, Map<String, Object> dbms) {
        super(parent, (Map<String, Object>)NullUtil.requireKeys(dbms, (Object)"typeName"));
        DbmsImpl prototype = new DbmsImpl(parent, dbms);
        this.enabled = prototype.isEnabled();
        this.id = prototype.getId();
        this.name = prototype.getName();
        this.alias = prototype.getAlias();
        this.typeName = prototype.getTypeName();
        this.ipAddress = prototype.getIpAddress();
        this.port = prototype.getPort();
        this.username = prototype.getUsername();
        this.schemas = Collections.unmodifiableList(super.children("schemas", ImmutableSchema::new).collect(Collectors.toList()));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getAlias() {
        return this.alias;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public Optional<String> getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public OptionalInt getPort() {
        return this.port;
    }

    @Override
    public Optional<String> getUsername() {
        return this.username;
    }

    public Stream<ImmutableSchema> schemas() {
        return this.schemas.stream();
    }

    @Override
    public Optional<Project> getParent() {
        return super.getParent().map(Project.class::cast);
    }

    @Override
    public String toString() {
        return DocumentUtil.toStringHelper(this);
    }
}

