/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.immutable;

import com.speedment.common.invariant.NullUtil;
import com.speedment.common.lazy.LazyReference;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.ForeignKeyColumn;
import com.speedment.runtime.config.internal.ForeignKeyColumnImpl;
import com.speedment.runtime.config.internal.immutable.ImmutableColumn;
import com.speedment.runtime.config.internal.immutable.ImmutableDocument;
import com.speedment.runtime.config.internal.immutable.ImmutableForeignKey;
import com.speedment.runtime.config.internal.immutable.ImmutableTable;
import com.speedment.runtime.config.util.DocumentUtil;
import java.util.Map;
import java.util.Optional;

public final class ImmutableForeignKeyColumn
extends ImmutableDocument
implements ForeignKeyColumn {
    private final transient String id;
    private final transient String name;
    private final transient int ordinalPosition;
    private final transient String foreignColumnName;
    private final transient String foreignTableName;
    private final transient LazyReference<Optional<ImmutableColumn>> foreignColumn;
    private final transient LazyReference<Optional<ImmutableTable>> foreignTable;
    private final transient LazyReference<Optional<ImmutableColumn>> column;

    ImmutableForeignKeyColumn(ImmutableForeignKey parent, Map<String, Object> fkc) {
        super(parent, (Map<String, Object>)NullUtil.requireKeys(fkc, (Object)"foreignColumnName", (Object)"foreignTableName"));
        ForeignKeyColumnImpl prototype = new ForeignKeyColumnImpl(parent, fkc);
        this.id = prototype.getId();
        this.name = prototype.getName();
        this.ordinalPosition = prototype.getOrdinalPosition();
        this.foreignTableName = prototype.getForeignTableName();
        this.foreignColumnName = prototype.getForeignColumnName();
        this.foreignTable = LazyReference.create();
        this.foreignColumn = LazyReference.create();
        this.column = LazyReference.create();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Override
    public String getForeignColumnName() {
        return this.foreignColumnName;
    }

    @Override
    public String getForeignTableName() {
        return this.foreignTableName;
    }

    public Optional<ImmutableColumn> findForeignColumn() {
        return (Optional)this.foreignColumn.getOrCompute(() -> ForeignKeyColumn.super.findForeignColumn().map(ImmutableColumn.class::cast));
    }

    public Optional<ImmutableTable> findForeignTable() {
        return (Optional)this.foreignTable.getOrCompute(() -> ForeignKeyColumn.super.findForeignTable().map(ImmutableTable.class::cast));
    }

    public Optional<ImmutableColumn> findColumn() {
        return (Optional)this.column.getOrCompute(() -> ForeignKeyColumn.super.findColumn().map(ImmutableColumn.class::cast));
    }

    @Override
    public Optional<ForeignKey> getParent() {
        return super.getParent().map(ForeignKey.class::cast);
    }

    @Override
    public String toString() {
        return DocumentUtil.toStringHelper(this);
    }
}

