/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.immutable;

import com.speedment.runtime.config.Index;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.internal.IndexImpl;
import com.speedment.runtime.config.internal.immutable.ImmutableDocument;
import com.speedment.runtime.config.internal.immutable.ImmutableIndexColumn;
import com.speedment.runtime.config.internal.immutable.ImmutableTable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ImmutableIndex
extends ImmutableDocument
implements Index {
    private final transient boolean enabled;
    private final transient String id;
    private final transient String name;
    private final transient boolean unique;
    private final transient List<ImmutableIndexColumn> indexColumns;

    ImmutableIndex(ImmutableTable parent, Map<String, Object> index) {
        super(parent, index);
        IndexImpl prototype = new IndexImpl(parent, index);
        this.enabled = prototype.isEnabled();
        this.id = prototype.getId();
        this.name = prototype.getName();
        this.unique = prototype.isUnique();
        this.indexColumns = Collections.unmodifiableList(super.children("indexColumns", ImmutableIndexColumn::new).collect(Collectors.toList()));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public Stream<ImmutableIndexColumn> indexColumns() {
        return this.indexColumns.stream();
    }

    @Override
    public Optional<Table> getParent() {
        return super.getParent().map(Table.class::cast);
    }
}

