/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.immutable;

import com.speedment.common.lazy.LazyReference;
import com.speedment.runtime.config.Index;
import com.speedment.runtime.config.IndexColumn;
import com.speedment.runtime.config.internal.IndexColumnImpl;
import com.speedment.runtime.config.internal.immutable.ImmutableColumn;
import com.speedment.runtime.config.internal.immutable.ImmutableDocument;
import com.speedment.runtime.config.internal.immutable.ImmutableIndex;
import com.speedment.runtime.config.parameter.OrderType;
import com.speedment.runtime.config.util.DocumentUtil;
import java.util.Map;
import java.util.Optional;

public final class ImmutableIndexColumn
extends ImmutableDocument
implements IndexColumn {
    private final transient String id;
    private final transient String name;
    private final transient int ordinalPosition;
    private final transient OrderType orderType;
    private final transient LazyReference<Optional<ImmutableColumn>> column;

    ImmutableIndexColumn(ImmutableIndex parent, Map<String, Object> ic) {
        super(parent, ic);
        IndexColumnImpl prototype = new IndexColumnImpl(parent, ic);
        this.id = prototype.getId();
        this.name = prototype.getName();
        this.ordinalPosition = prototype.getOrdinalPosition();
        this.orderType = prototype.getOrderType();
        this.column = LazyReference.create();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Override
    public OrderType getOrderType() {
        return this.orderType;
    }

    public Optional<ImmutableColumn> findColumn() {
        return (Optional)this.column.getOrCompute(() -> IndexColumn.super.findColumn().map(ImmutableColumn.class::cast));
    }

    @Override
    public Optional<Index> getParent() {
        return super.getParent().map(Index.class::cast);
    }

    @Override
    public String toString() {
        return DocumentUtil.toStringHelper(this);
    }
}

