/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.immutable;

import com.speedment.common.mapstream.MapStream;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.exception.SpeedmentConfigException;
import com.speedment.runtime.config.internal.ProjectImpl;
import com.speedment.runtime.config.internal.immutable.ImmutableDbms;
import com.speedment.runtime.config.internal.immutable.ImmutableDocument;
import com.speedment.runtime.config.internal.immutable.ImmutableTable;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.config.util.DocumentUtil;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ImmutableProject
extends ImmutableDocument
implements Project {
    private final transient boolean enabled;
    private final transient String id;
    private final transient String name;
    private final transient String companyName;
    private final transient Optional<String> packageName;
    private final transient String packageLocation;
    private final transient Optional<Path> configPath;
    private final transient List<ImmutableDbms> dbmses;
    private final transient Map<String, ImmutableTable> tablesByName;

    ImmutableProject(Map<String, Object> project) {
        super(project);
        ProjectImpl prototype = new ProjectImpl(project);
        this.enabled = prototype.isEnabled();
        this.id = prototype.getId();
        this.name = prototype.getName();
        this.companyName = prototype.getCompanyName();
        this.packageName = prototype.getPackageName();
        this.packageLocation = prototype.getPackageLocation();
        this.configPath = prototype.getConfigPath();
        this.dbmses = Collections.unmodifiableList(super.children("dbmses", ImmutableDbms::new).collect(Collectors.toList()));
        this.tablesByName = MapStream.fromValues(DocumentDbUtil.traverseOver(this, ImmutableTable.class), table -> DocumentUtil.relativeName(table, Dbms.class, DocumentUtil.Name.DATABASE_NAME)).toMap();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCompanyName() {
        return this.companyName;
    }

    @Override
    public Optional<String> getPackageName() {
        return this.packageName;
    }

    @Override
    public String getPackageLocation() {
        return this.packageLocation;
    }

    @Override
    public Optional<Path> getConfigPath() {
        return this.configPath;
    }

    public Stream<ImmutableDbms> dbmses() {
        return this.dbmses.stream();
    }

    @Override
    public ImmutableTable findTableByName(String fullName) {
        ImmutableTable table = this.tablesByName.get(fullName);
        if (table == null) {
            throw new SpeedmentConfigException("Unable to find table '" + fullName + "' in immutable config model.");
        }
        return table;
    }

    public static ImmutableProject wrap(Project project) {
        return new ImmutableProject(project.getData());
    }
}

