/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.immutable;

import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.internal.SchemaImpl;
import com.speedment.runtime.config.internal.immutable.ImmutableDbms;
import com.speedment.runtime.config.internal.immutable.ImmutableDocument;
import com.speedment.runtime.config.internal.immutable.ImmutableTable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ImmutableSchema
extends ImmutableDocument
implements Schema {
    private final transient boolean enabled;
    private final transient String id;
    private final transient String name;
    private final transient Optional<String> alias;
    private final transient boolean defaultSchema;
    private final transient List<ImmutableTable> tables;

    ImmutableSchema(ImmutableDbms parent, Map<String, Object> schema) {
        super(parent, schema);
        SchemaImpl prototype = new SchemaImpl(parent, schema);
        this.enabled = prototype.isEnabled();
        this.id = prototype.getId();
        this.name = prototype.getName();
        this.alias = prototype.getAlias();
        this.defaultSchema = prototype.isDefaultSchema();
        this.tables = Collections.unmodifiableList(super.children("tables", ImmutableTable::new).collect(Collectors.toList()));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getAlias() {
        return this.alias;
    }

    @Override
    public boolean isDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public Optional<Dbms> getParent() {
        return super.getParent().map(Dbms.class::cast);
    }

    public Stream<ImmutableTable> tables() {
        return this.tables.stream();
    }
}

