/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.immutable;

import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.internal.TableImpl;
import com.speedment.runtime.config.internal.immutable.ImmutableColumn;
import com.speedment.runtime.config.internal.immutable.ImmutableDocument;
import com.speedment.runtime.config.internal.immutable.ImmutableForeignKey;
import com.speedment.runtime.config.internal.immutable.ImmutableIndex;
import com.speedment.runtime.config.internal.immutable.ImmutablePrimaryKeyColumn;
import com.speedment.runtime.config.internal.immutable.ImmutableSchema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ImmutableTable
extends ImmutableDocument
implements Table {
    private final transient boolean enabled;
    private final transient String id;
    private final transient String name;
    private final transient Optional<String> alias;
    private final transient Optional<String> packageName;
    private final transient boolean view;
    private final transient List<ImmutableColumn> columns;
    private final transient List<ImmutableIndex> indexes;
    private final transient List<ImmutableForeignKey> foreignKeys;
    private final transient List<ImmutablePrimaryKeyColumn> primaryKeyColumns;

    ImmutableTable(ImmutableSchema parent, Map<String, Object> table) {
        super(parent, table);
        TableImpl prototype = new TableImpl(parent, table);
        this.enabled = prototype.isEnabled();
        this.id = prototype.getId();
        this.name = prototype.getName();
        this.alias = prototype.getAlias();
        this.packageName = prototype.getPackageName();
        this.view = prototype.isView();
        this.columns = Collections.unmodifiableList(super.children("columns", ImmutableColumn::new).collect(Collectors.toList()));
        this.indexes = Collections.unmodifiableList(super.children("indexes", ImmutableIndex::new).collect(Collectors.toList()));
        this.foreignKeys = Collections.unmodifiableList(super.children("foreignKeys", ImmutableForeignKey::new).collect(Collectors.toList()));
        this.primaryKeyColumns = Collections.unmodifiableList(super.children("primaryKeyColumns", ImmutablePrimaryKeyColumn::new).collect(Collectors.toList()));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getAlias() {
        return this.alias;
    }

    @Override
    public Optional<String> getPackageName() {
        return this.packageName;
    }

    @Override
    public boolean isView() {
        return this.view;
    }

    public Stream<ImmutableColumn> columns() {
        return this.columns.stream();
    }

    public Stream<ImmutableIndex> indexes() {
        return this.indexes.stream();
    }

    public Stream<ImmutableForeignKey> foreignKeys() {
        return this.foreignKeys.stream();
    }

    public Stream<ImmutablePrimaryKeyColumn> primaryKeyColumns() {
        return this.primaryKeyColumns.stream();
    }

    @Override
    public Optional<Schema> getParent() {
        return super.getParent().map(Schema.class::cast);
    }
}

