/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.internal.util;

import com.speedment.common.invariant.NullUtil;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public final class Trees {
    public static <T> Stream<? extends T> walk(T first, Function<T, T> traverser) {
        NullUtil.requireNonNulls(first, traverser);
        return Trees.walk(first, traverser, WalkingOrder.FORWARD, Stream.builder()).build();
    }

    public static <T> Stream<? extends T> walk(T first, Function<T, T> traverser, WalkingOrder order) {
        NullUtil.requireNonNulls(first, traverser, (Object)((Object)order));
        return Trees.walk(first, traverser, order, Stream.builder()).build();
    }

    public static <T> Stream<? extends T> walkOptional(T first, Function<T, Optional<T>> traverser) {
        NullUtil.requireNonNulls(first, traverser);
        return Trees.walkOptional(first, traverser, WalkingOrder.FORWARD, Stream.builder()).build();
    }

    public static <T> Stream<? extends T> walkOptional(T first, Function<T, Optional<T>> traverser, WalkingOrder order) {
        NullUtil.requireNonNulls(first, traverser, (Object)((Object)order));
        return Trees.walkOptional(first, traverser, order, Stream.builder()).build();
    }

    public static <T> Stream<? extends T> traverse(T first, Function<T, Stream<? extends T>> traverser, TraversalOrder traversalOrder) {
        NullUtil.requireNonNulls(first, traverser, (Object)((Object)traversalOrder));
        if (traversalOrder == TraversalOrder.BREADTH_FIRST) {
            return Trees.traverseBredthFirst(first, traverser, Stream.builder()).build();
        }
        return Trees.traverse(first, traverser, traversalOrder, Stream.builder()).build();
    }

    private static <T> Stream.Builder<? extends T> walkOptional(T first, Function<T, Optional<T>> traverser, WalkingOrder order, Stream.Builder<T> builder) {
        NullUtil.requireNonNulls(first, traverser, (Object)((Object)order), builder);
        if (order == WalkingOrder.FORWARD) {
            builder.add(first);
        }
        traverser.apply(first).ifPresent(p -> Trees.walkOptional(p, traverser, order, builder));
        if (order == WalkingOrder.BACKWARD) {
            builder.add(first);
        }
        return builder;
    }

    private static <T> Stream.Builder<? extends T> walk(T first, Function<T, T> traverser, WalkingOrder order, Stream.Builder<T> builder) {
        T next;
        NullUtil.requireNonNulls(first, traverser, (Object)((Object)order), builder);
        if (order == WalkingOrder.FORWARD) {
            builder.add(first);
        }
        if ((next = traverser.apply(first)) != null) {
            Trees.walk(next, traverser, order, builder);
        }
        if (order == WalkingOrder.BACKWARD) {
            builder.add(first);
        }
        return builder;
    }

    private static <T> Stream.Builder<? extends T> traverse(T first, Function<T, Stream<? extends T>> traverser, TraversalOrder traversalOrder, Stream.Builder<T> builder) {
        Stream<Object> next;
        NullUtil.requireNonNulls(first, traverser, (Object)((Object)traversalOrder), builder);
        if (first == null) {
            return builder;
        }
        if (traversalOrder == TraversalOrder.DEPTH_FIRST_PRE) {
            builder.add(first);
        }
        if ((next = traverser.apply(first)) != null) {
            next.filter(Objects::nonNull).forEach(n -> Trees.traverse(n, traverser, traversalOrder, builder));
        }
        if (traversalOrder == TraversalOrder.DEPTH_FIRST_POST) {
            builder.add(first);
        }
        return builder;
    }

    private static <T> Stream.Builder<? extends T> traverseBredthFirst(T first, Function<T, Stream<? extends T>> traverser, Stream.Builder<T> builder) {
        NullUtil.requireNonNulls(first, traverser, builder);
        if (first == null) {
            return builder;
        }
        ArrayDeque<T> q = new ArrayDeque<T>();
        q.add(first);
        while (!q.isEmpty()) {
            Object node = q.poll();
            builder.add(node);
            traverser.apply(node).filter(Objects::nonNull).forEach(q::add);
        }
        return builder;
    }

    private Trees() {
        throw new UnsupportedOperationException();
    }

    public static enum WalkingOrder {
        FORWARD,
        BACKWARD;

    }

    public static enum TraversalOrder {
        DEPTH_FIRST_PRE,
        DEPTH_FIRST_POST,
        BREADTH_FIRST;

    }
}

