/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.trait;

import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.exception.SpeedmentConfigException;
import com.speedment.runtime.config.trait.HasChildren;
import com.speedment.runtime.config.trait.HasMainInterface;
import com.speedment.runtime.config.trait.HasNameView;
import com.speedment.runtime.config.util.TraitUtil;
import java.util.Optional;

public interface HasName
extends Document,
HasMainInterface {
    public static final String NAME = "name";

    default public String getName() throws SpeedmentConfigException {
        Optional<String> name = this.getAsString(NAME);
        if (name.isPresent()) {
            return name.get();
        }
        if (this.getParent().filter(HasChildren.class::isInstance).isPresent()) {
            String defaultName = this.getParent().map(HasChildren.class::cast).map(parent -> parent.defaultNameFor(this)).get();
            this.getData().put(NAME, defaultName);
            return defaultName;
        }
        if (this instanceof Project) {
            return Project.class.getSimpleName();
        }
        throw new SpeedmentConfigException("A name is required for node of type '" + this.getClass().getSimpleName() + "'.");
    }

    public static HasName of(Document document) {
        return TraitUtil.viewOf(document, HasName.class, HasNameView::new);
    }
}

