/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.trait;

import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.trait.HasNullableView;
import com.speedment.runtime.config.util.TraitUtil;

public interface HasNullable
extends Document {
    public static final String NULLABLE = "nullable";
    public static final String NULLABLE_IMPLEMENTATION = "nullableImplementation";

    default public boolean isNullable() {
        return this.getAsBoolean(NULLABLE).orElse(true);
    }

    default public ImplementAs getNullableImplementation() {
        String impl = this.getAsString(NULLABLE_IMPLEMENTATION).orElse(null);
        if (impl == null) {
            return ImplementAs.OPTIONAL;
        }
        return ImplementAs.valueOf(impl);
    }

    public static HasNullable of(Document document) {
        return TraitUtil.viewOf(document, HasNullable.class, HasNullableView::new);
    }

    public static enum ImplementAs {
        OPTIONAL,
        WRAPPER;

    }
}

