/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.trait;

import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.exception.SpeedmentConfigException;
import com.speedment.runtime.config.util.DocumentUtil;
import java.util.Optional;

public interface HasTypeMapper
extends Document {
    public static final String TYPE_MAPPER = "typeMapper";
    public static final String DATABASE_TYPE = "databaseType";

    default public Optional<String> getTypeMapper() {
        return this.getAsString(TYPE_MAPPER);
    }

    default public String getDatabaseType() {
        return this.getAsString(DATABASE_TYPE).orElseThrow(DocumentUtil.newNoSuchElementExceptionFor(this, DATABASE_TYPE));
    }

    default public Class<?> findDatabaseType() {
        String name = this.getDatabaseType();
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            throw new SpeedmentConfigException("Could not find database type: '" + name + "'.", ex);
        }
    }
}

