/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.util;

import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.ForeignKeyColumn;
import com.speedment.runtime.config.Index;
import com.speedment.runtime.config.IndexColumn;
import com.speedment.runtime.config.PrimaryKeyColumn;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.exception.SpeedmentConfigException;
import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.config.identifier.trait.HasColumnName;
import com.speedment.runtime.config.identifier.trait.HasDbmsName;
import com.speedment.runtime.config.identifier.trait.HasSchemaName;
import com.speedment.runtime.config.identifier.trait.HasTableName;
import com.speedment.runtime.config.trait.HasColumn;
import com.speedment.runtime.config.trait.HasEnabled;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public final class DocumentDbUtil {
    public static Stream<? extends Document> traverseOver(Project project) {
        return Stream.concat(project.dbmses(), project.dbmses().flatMap(DocumentDbUtil::traverseOver));
    }

    public static Stream<? extends Document> traverseOver(Dbms dbms) {
        return Stream.concat(dbms.schemas(), dbms.schemas().flatMap(DocumentDbUtil::traverseOver));
    }

    public static Stream<? extends Document> traverseOver(Schema schema) {
        return Stream.concat(schema.tables(), schema.tables().flatMap(DocumentDbUtil::traverseOver));
    }

    public static Stream<? extends Document> traverseOver(Table table) {
        return Stream.of(table.columns(), table.columns().flatMap(DocumentDbUtil::traverseOver), table.primaryKeyColumns(), table.primaryKeyColumns().flatMap(DocumentDbUtil::traverseOver), table.indexes(), table.indexes().flatMap(DocumentDbUtil::traverseOver), table.foreignKeys(), table.foreignKeys().flatMap(DocumentDbUtil::traverseOver)).flatMap(Function.identity());
    }

    public static Stream<? extends Document> traverseOver(Column column) {
        return Stream.empty();
    }

    public static Stream<? extends Document> traverseOver(PrimaryKeyColumn primaryKeyColumn) {
        return Stream.empty();
    }

    public static Stream<? extends Document> traverseOver(Index index) {
        return Stream.concat(index.indexColumns(), index.indexColumns().flatMap(DocumentDbUtil::traverseOver));
    }

    public static Stream<? extends Document> traverseOver(IndexColumn indexColumn) {
        return Stream.empty();
    }

    public static Stream<? extends Document> traverseOver(ForeignKey foreignKey) {
        return Stream.concat(foreignKey.foreignKeyColumns(), foreignKey.foreignKeyColumns().flatMap(DocumentDbUtil::traverseOver));
    }

    public static Stream<? extends Document> traverseOver(ForeignKeyColumn foreignKeyColumn) {
        return Stream.empty();
    }

    public static <T> Stream<T> traverseOver(Project project, Class<T> clazz) {
        if (Dbms.class.isAssignableFrom(clazz)) {
            return project.dbmses().map(clazz::cast);
        }
        return project.dbmses().flatMap(dbms -> DocumentDbUtil.traverseOver(dbms, clazz));
    }

    public static <T> Stream<T> traverseOver(Dbms dbms, Class<T> clazz) {
        if (Schema.class.isAssignableFrom(clazz)) {
            return dbms.schemas().map(clazz::cast);
        }
        return dbms.schemas().flatMap(schema -> DocumentDbUtil.traverseOver(schema, clazz));
    }

    public static <T> Stream<T> traverseOver(Schema schema, Class<T> clazz) {
        if (Table.class.isAssignableFrom(clazz)) {
            return schema.tables().map(clazz::cast);
        }
        return schema.tables().flatMap(table -> DocumentDbUtil.traverseOver(table, clazz));
    }

    public static <T> Stream<T> traverseOver(Table table, Class<T> clazz) {
        if (Column.class.isAssignableFrom(clazz)) {
            return table.columns().map(clazz::cast);
        }
        if (PrimaryKeyColumn.class.isAssignableFrom(clazz)) {
            return table.primaryKeyColumns().map(clazz::cast);
        }
        if (Index.class.isAssignableFrom(clazz)) {
            return table.indexes().map(clazz::cast);
        }
        if (ForeignKey.class.isAssignableFrom(clazz)) {
            return table.foreignKeys().map(clazz::cast);
        }
        Stream.Builder sb = Stream.builder();
        table.columns().flatMap(c -> DocumentDbUtil.traverseOver(c, clazz)).forEachOrdered(sb::accept);
        table.primaryKeyColumns().flatMap(c -> DocumentDbUtil.traverseOver(c, clazz)).forEachOrdered(sb::accept);
        table.indexes().flatMap(c -> DocumentDbUtil.traverseOver(c, clazz)).forEachOrdered(sb::accept);
        table.foreignKeys().flatMap(c -> DocumentDbUtil.traverseOver(c, clazz)).forEachOrdered(sb::accept);
        return sb.build();
    }

    public static <T> Stream<T> traverseOver(Column column, Class<T> clazz) {
        return Stream.empty();
    }

    public static <T> Stream<T> traverseOver(PrimaryKeyColumn pkColumn, Class<T> clazz) {
        return Stream.empty();
    }

    public static <T> Stream<T> traverseOver(Index index, Class<T> clazz) {
        if (IndexColumn.class.isAssignableFrom(clazz)) {
            return index.indexColumns().map(clazz::cast);
        }
        return index.indexColumns().flatMap(ic -> DocumentDbUtil.traverseOver(ic, clazz));
    }

    public static <T> Stream<T> traverseOver(IndexColumn indexColumn, Class<T> clazz) {
        return Stream.empty();
    }

    public static <T> Stream<T> traverseOver(ForeignKey fk, Class<T> clazz) {
        if (ForeignKeyColumn.class.isAssignableFrom(clazz)) {
            return fk.foreignKeyColumns().map(clazz::cast);
        }
        return fk.foreignKeyColumns().flatMap(fcc -> DocumentDbUtil.traverseOver(fcc, clazz));
    }

    public static <T> Stream<T> traverseOver(ForeignKeyColumn foreignKeyColumn, Class<T> clazz) {
        return Stream.empty();
    }

    public static Stream<? extends Document> typedChildrenOf(Table table) {
        Stream[] streamArray = new Stream[4];
        streamArray[0] = table.columns().map(Document.class::cast);
        streamArray[1] = table.primaryKeyColumns().map(Document.class::cast);
        streamArray[2] = table.indexes().map(Document.class::cast);
        streamArray[3] = table.foreignKeys().map(Document.class::cast);
        return Stream.of(streamArray).flatMap(Function.identity());
    }

    public static boolean isUnique(Column column) throws SpeedmentConfigException {
        Table table = (Table)column.getParentOrThrow();
        return table.indexes().filter(i -> i.indexColumns().count() == 1L).filter(Index::isUnique).filter(HasEnabled::isEnabled).flatMap(Index::indexColumns).map(HasColumn::findColumn).filter(Optional::isPresent).map(Optional::get).anyMatch(col -> DocumentDbUtil.isSame(column, col)) || table.primaryKeyColumns().count() == 1L && table.primaryKeyColumns().map(HasColumn::findColumn).filter(Optional::isPresent).map(Optional::get).anyMatch(col -> DocumentDbUtil.isSame(column, col));
    }

    public static boolean isAllAncestorsEnabled(Document document) {
        return HasEnabled.test(document) && document.ancestors().noneMatch(doc -> !HasEnabled.test(doc));
    }

    public static Optional<? extends Column> referencedColumnIfPresent(Project project, ColumnIdentifier<?> identifier) {
        return DocumentDbUtil.referencedColumnIfPresent(project, identifier.getDbmsName(), identifier.getSchemaName(), identifier.getTableName(), identifier.getColumnName());
    }

    public static Optional<? extends Table> referencedTableIfPresent(Project project, ColumnIdentifier<?> identifier) {
        return DocumentDbUtil.referencedTableIfPresent(project, identifier.getDbmsName(), identifier.getSchemaName(), identifier.getTableName());
    }

    public static Optional<? extends Schema> referencedSchemaIfPresent(Project project, ColumnIdentifier<?> identifier) {
        return DocumentDbUtil.referencedSchemaIfPresent(project, identifier.getDbmsName(), identifier.getSchemaName());
    }

    public static Optional<? extends Dbms> referencedDbmsIfPresent(Project project, ColumnIdentifier<?> identifier) {
        return DocumentDbUtil.referencedDbmsIfPresent(project, identifier.getDbmsName());
    }

    public static Optional<? extends Column> referencedColumnIfPresent(Project project, String dbmsId, String schemaId, String tableId, String columnId) {
        return DocumentDbUtil.referencedTableIfPresent(project, dbmsId, schemaId, tableId).flatMap(table -> table.columns().filter(column -> columnId.equals(column.getId())).findAny());
    }

    public static Optional<? extends Table> referencedTableIfPresent(Project project, String dbmsId, String schemaId, String tableId) {
        return DocumentDbUtil.referencedSchemaIfPresent(project, dbmsId, schemaId).flatMap(schema -> schema.tables().filter(table -> tableId.equals(table.getId())).findAny());
    }

    public static Optional<? extends Schema> referencedSchemaIfPresent(Project project, String dbmsId, String schemaId) {
        return DocumentDbUtil.referencedDbmsIfPresent(project, dbmsId).flatMap(dbms -> dbms.schemas().filter(schema -> schemaId.equals(schema.getId())).findAny());
    }

    public static Optional<? extends Dbms> referencedDbmsIfPresent(Project project, String dbmsId) {
        return project.dbmses().filter(dbms -> dbmsId.equals(dbms.getId())).findAny();
    }

    public static <T extends HasDbmsName & HasSchemaName & HasColumnName> Column referencedColumn(Project project, T identifier) {
        return DocumentDbUtil.referencedColumn(project, identifier.getDbmsName(), ((HasSchemaName)identifier).getSchemaName(), ((HasTableName)identifier).getTableName(), ((HasColumnName)identifier).getColumnName());
    }

    public static <T extends HasDbmsName & HasSchemaName> Table referencedTable(Project project, T identifier) {
        return DocumentDbUtil.referencedTable(project, identifier.getDbmsName(), ((HasSchemaName)identifier).getSchemaName(), ((HasTableName)identifier).getTableName());
    }

    public static <T extends HasDbmsName & HasSchemaName> Schema referencedSchema(Project project, T identifier) {
        return DocumentDbUtil.referencedSchema(project, identifier.getDbmsName(), ((HasSchemaName)identifier).getSchemaName());
    }

    public static Dbms referencedDbms(Project project, HasDbmsName identifier) {
        return DocumentDbUtil.referencedDbms(project, identifier.getDbmsName());
    }

    public static Column referencedColumn(Project project, String dbmsName, String schemaName, String tableName, String columnName) {
        return DocumentDbUtil.referencedColumnIfPresent(project, dbmsName, schemaName, tableName, columnName).orElseThrow(() -> new SpeedmentConfigException("Could not find referenced " + Column.class.getSimpleName() + " with name '" + columnName + "'."));
    }

    public static Table referencedTable(Project project, String dbmsId, String schemaId, String tableId) {
        return DocumentDbUtil.referencedSchema(project, dbmsId, schemaId).tables().filter(table -> tableId.equals(table.getId())).findAny().orElseThrow(() -> new SpeedmentConfigException("Could not find referenced " + Table.class.getSimpleName() + " with name '" + tableId + "'."));
    }

    public static Schema referencedSchema(Project project, String dbmsId, String schemaId) {
        return DocumentDbUtil.referencedDbms(project, dbmsId).schemas().filter(schema -> schemaId.equals(schema.getId())).findAny().orElseThrow(() -> new SpeedmentConfigException("Could not find referenced " + Schema.class.getSimpleName() + " with name '" + schemaId + "'."));
    }

    public static Dbms referencedDbms(Project project, String dbmsId) {
        return project.dbmses().filter(dbms -> dbmsId.equals(dbms.getId())).findAny().orElseThrow(() -> new SpeedmentConfigException("Could not find referenced " + Dbms.class.getSimpleName() + " with name '" + dbmsId + "'."));
    }

    public static boolean isSame(Column first, Column second) {
        if (first.getId().equals(second.getId())) {
            Table firstParent = (Table)first.getParentOrThrow();
            Table secondParent = (Table)second.getParentOrThrow();
            return DocumentDbUtil.isSame(firstParent, secondParent);
        }
        return false;
    }

    public static boolean isSame(IndexColumn first, IndexColumn second) {
        if (first.getId().equals(second.getId())) {
            Index firstParent = (Index)first.getParentOrThrow();
            Index secondParent = (Index)second.getParentOrThrow();
            return DocumentDbUtil.isSame(firstParent, secondParent);
        }
        return false;
    }

    public static boolean isSame(Index first, Index second) {
        if (first.getId().equals(second.getId())) {
            Table firstParent = (Table)first.getParentOrThrow();
            Table secondParent = (Table)second.getParentOrThrow();
            return DocumentDbUtil.isSame(firstParent, secondParent);
        }
        return false;
    }

    public static boolean isSame(PrimaryKeyColumn first, PrimaryKeyColumn second) {
        if (first.getId().equals(second.getId())) {
            Table firstParent = (Table)first.getParentOrThrow();
            Table secondParent = (Table)second.getParentOrThrow();
            return DocumentDbUtil.isSame(firstParent, secondParent);
        }
        return false;
    }

    public static boolean isSame(ForeignKeyColumn first, ForeignKeyColumn second) {
        if (first.getId().equals(second.getId())) {
            ForeignKey firstParent = (ForeignKey)first.getParentOrThrow();
            ForeignKey secondParent = (ForeignKey)second.getParentOrThrow();
            return DocumentDbUtil.isSame(firstParent, secondParent);
        }
        return false;
    }

    public static boolean isSame(ForeignKey first, ForeignKey second) {
        if (first.getId().equals(second.getId())) {
            Table firstParent = (Table)first.getParentOrThrow();
            Table secondParent = (Table)second.getParentOrThrow();
            return DocumentDbUtil.isSame(firstParent, secondParent);
        }
        return false;
    }

    public static boolean isSame(Table first, Table second) {
        if (first.getId().equals(second.getId())) {
            Schema firstParent = (Schema)first.getParentOrThrow();
            Schema secondParent = (Schema)second.getParentOrThrow();
            return DocumentDbUtil.isSame(firstParent, secondParent);
        }
        return false;
    }

    public static boolean isSame(Schema first, Schema second) {
        if (first.getId().equals(second.getId())) {
            Dbms firstParent = (Dbms)first.getParentOrThrow();
            Dbms secondParent = (Dbms)second.getParentOrThrow();
            return DocumentDbUtil.isSame(firstParent, secondParent);
        }
        return false;
    }

    public static boolean isSame(Dbms first, Dbms second) {
        if (first.getId().equals(second.getId())) {
            Project firstParent = (Project)first.getParentOrThrow();
            Project secondParent = (Project)second.getParentOrThrow();
            return DocumentDbUtil.isSame(firstParent, secondParent);
        }
        return false;
    }

    public static boolean isSame(Project first, Project second) {
        return first.getId().equals(second.getId());
    }

    private DocumentDbUtil() {
        throw new UnsupportedOperationException();
    }
}

