/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.util;

import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.exception.SpeedmentConfigException;
import com.speedment.runtime.config.internal.ProjectImpl;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class DocumentTranscoder {
    public static final String ROOT = "config";

    public static String save(Project project, Encoder encoder) throws SpeedmentConfigException {
        if (project == null) {
            return "null";
        }
        try {
            LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
            root.put(ROOT, project.getData());
            return encoder.encode(root);
        }
        catch (IllegalArgumentException ex) {
            throw new SpeedmentConfigException(ex);
        }
    }

    public static void save(Project project, Path location, Encoder encoder) throws SpeedmentConfigException {
        try {
            Files.write(location, DocumentTranscoder.save(project, encoder).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new SpeedmentConfigException("Could not save json-file to path '" + location + "'.", ex);
        }
    }

    public static Project load(String json, Decoder decoder) throws SpeedmentConfigException {
        Objects.requireNonNull(json, "No json value specified.");
        try {
            Map<String, Object> root = decoder.decode(json);
            Map data = (Map)root.get(ROOT);
            if (!data.containsKey("appId")) {
                data.put("appId", UUID.randomUUID().toString());
            }
            return new ProjectImpl(data);
        }
        catch (Exception ex) {
            throw new SpeedmentConfigException(ex);
        }
    }

    public static Project load(Path location, Decoder decoder) throws SpeedmentConfigException {
        try {
            byte[] content = Files.readAllBytes(location);
            return DocumentTranscoder.load(new String(content, StandardCharsets.UTF_8), decoder);
        }
        catch (IOException ex) {
            throw new SpeedmentConfigException("Could not load json-file from path '" + location + "'.", ex);
        }
    }

    private DocumentTranscoder() {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    public static interface Decoder {
        public Map<String, Object> decode(String var1);
    }

    @FunctionalInterface
    public static interface Encoder {
        public String encode(Map<String, Object> var1);
    }
}

