/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.config.util;

import com.speedment.common.mapstream.MapStream;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.internal.util.Trees;
import com.speedment.runtime.config.trait.HasAlias;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.trait.HasParent;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DocumentUtil {
    private static final Function<Object, Object> VALUE_MAPPER = o -> {
        if (o instanceof List) {
            return "[" + ((List)o).size() + "]";
        }
        return o;
    };

    public static Stream<? extends Document> traverseOver(Document document) {
        Objects.requireNonNull(document);
        return Trees.traverse(document, d -> d.children(), Trees.TraversalOrder.DEPTH_FIRST_PRE);
    }

    public static <E extends Document> Optional<E> ancestor(Document document, Class<E> clazz) {
        Objects.requireNonNull(document);
        Objects.requireNonNull(clazz);
        return document.ancestors().filter(clazz::isInstance).map(clazz::cast).findFirst();
    }

    public static <E extends Document> Stream<E> childrenOf(Document document, BiFunction<Document, Map<String, Object>, E> childConstructor) {
        Objects.requireNonNull(document);
        Objects.requireNonNull(childConstructor);
        return document.getData().values().stream().filter(obj -> obj instanceof List).map(list -> (List)list).flatMap(list -> list.stream()).filter(obj -> obj instanceof Map).map(map -> (Map)map).map(map -> (Document)childConstructor.apply(document, (Map<String, Object>)map));
    }

    public static Map<String, Object> newDocument(Document parent, String key) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(key);
        List children = parent.get(key).map(DocumentUtil::castToDocumentList).orElseGet(() -> {
            CopyOnWriteArrayList list = new CopyOnWriteArrayList();
            parent.put(key, list);
            return list;
        });
        ConcurrentSkipListMap<String, Object> child = new ConcurrentSkipListMap<String, Object>();
        children.add(child);
        return child;
    }

    public static <T extends Document & HasName, D extends Document & HasName> String relativeName(D document, Class<T> from, Name name) {
        return DocumentUtil.relativeName(document, from, name, Function.identity());
    }

    public static <T extends Document & HasName, D extends Document & HasName> String relativeName(D document, Class<T> from, Name name, Function<String, String> nameMapper) {
        return DocumentUtil.relativeName(document, from, name, ".", nameMapper);
    }

    public static <T extends Document & HasName, D extends Document & HasName> String relativeName(D document, Class<T> from, Name name, CharSequence separator, Function<String, String> nameMapper) {
        Objects.requireNonNull(document);
        Objects.requireNonNull(from);
        Objects.requireNonNull(nameMapper);
        StringJoiner sj = new StringJoiner(separator).setEmptyValue("");
        List ancestors = document.ancestors().map(HasAlias::of).collect(Collectors.toList());
        boolean add = false;
        for (HasAlias parent : ancestors) {
            if (!add && !parent.mainInterface().isAssignableFrom(from)) continue;
            sj.add(nameMapper.apply(name.of(parent)));
            add = true;
        }
        sj.add(nameMapper.apply(name.of(HasAlias.of(document))));
        return sj.toString();
    }

    public static <DOC extends Document> DOC deepCopy(DOC document, Function<Map<String, Object>, DOC> constructor) {
        return (DOC)((Document)constructor.apply(DocumentUtil.deepCopyMap(document.getData())));
    }

    public static <P extends Document, DOC extends Document & HasParent<P>> DOC deepCopy(DOC document, BiFunction<P, Map<String, Object>, DOC> constructor) {
        return (DOC)((Document)constructor.apply(((HasParent<P>)document).getParent().orElse(null), DocumentUtil.deepCopyMap(document.getData())));
    }

    public static Supplier<NoSuchElementException> newNoSuchElementExceptionFor(Document document, String key) {
        return () -> new NoSuchElementException("An attribute with the key '" + key + "' could not be found in " + document + " with name (" + Optional.ofNullable(document).flatMap(doc -> doc.getAsString("name")).orElse("null") + ")");
    }

    public static String toStringHelper(Document document) {
        return document.getClass().getSimpleName() + " {" + MapStream.of(document.getData()).mapValue(VALUE_MAPPER).map((k, v) -> "\"" + k + "\": " + (v == null ? "null" : (v instanceof String ? "\"" + v + "\"" : v.toString()))).collect(Collectors.joining(", ")) + "}";
    }

    public static List<Map<String, Object>> castToDocumentList(Object obj) {
        List list = (List)obj;
        return list;
    }

    private static <K, V> Map<K, V> deepCopyMap(Map<K, V> original) {
        ConcurrentSkipListMap copy = new ConcurrentSkipListMap();
        MapStream.of(original).mapValue(DocumentUtil::deepCopyObject).forEachOrdered(copy::put);
        return copy;
    }

    private static <V> List<V> deepCopyList(List<V> original) {
        CopyOnWriteArrayList copy = new CopyOnWriteArrayList();
        original.stream().map(DocumentUtil::deepCopyObject).forEachOrdered(copy::add);
        return copy;
    }

    private static <V> V deepCopyObject(V original) {
        if (String.class.isAssignableFrom(original.getClass()) || Number.class.isAssignableFrom(original.getClass()) || Boolean.class.isAssignableFrom(original.getClass()) || Enum.class.isAssignableFrom(original.getClass())) {
            return original;
        }
        if (List.class.isAssignableFrom(original.getClass())) {
            List<V> result = DocumentUtil.deepCopyList((List)original);
            return (V)result;
        }
        if (Map.class.isAssignableFrom(original.getClass())) {
            Map result = DocumentUtil.deepCopyMap((Map)original);
            return (V)result;
        }
        throw new UnsupportedOperationException("Can't deep copy unknown type '" + original.getClass() + "'.");
    }

    private DocumentUtil() {
        throw new UnsupportedOperationException();
    }

    public static enum Name {
        DATABASE_NAME,
        JAVA_NAME;


        public String of(HasAlias document) {
            switch (this) {
                case DATABASE_NAME: {
                    return document.getName();
                }
                case JAVA_NAME: {
                    return document.getJavaName();
                }
            }
            throw new UnsupportedOperationException("Unknown enum constant '" + this.name() + "'.");
        }
    }
}

