/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.BooleanField;
import com.speedment.runtime.field.internal.method.GetBooleanImpl;
import com.speedment.runtime.field.internal.predicate.booleans.BooleanEqualPredicate;
import com.speedment.runtime.field.internal.predicate.booleans.BooleanNotEqualPredicate;
import com.speedment.runtime.field.method.BooleanGetter;
import com.speedment.runtime.field.method.BooleanSetter;
import com.speedment.runtime.field.method.GetBoolean;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Objects;
import java.util.function.Predicate;

public final class BooleanFieldImpl<ENTITY, D>
implements BooleanField<ENTITY, D> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetBoolean<ENTITY, D> getter;
    private final BooleanSetter<ENTITY> setter;
    private final TypeMapper<D, Boolean> typeMapper;
    private final boolean unique;

    public BooleanFieldImpl(ColumnIdentifier<ENTITY> identifier, BooleanGetter<ENTITY> getter, BooleanSetter<ENTITY> setter, TypeMapper<D, Boolean> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetBooleanImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public BooleanSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetBoolean<ENTITY, D> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, Boolean> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public FieldPredicate<ENTITY> equal(boolean value) {
        return new BooleanEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> notEqual(boolean value) {
        return new BooleanNotEqualPredicate(this, value);
    }
}

