/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.CharField;
import com.speedment.runtime.field.internal.comparator.CharFieldComparator;
import com.speedment.runtime.field.internal.comparator.CharFieldComparatorImpl;
import com.speedment.runtime.field.internal.method.GetCharImpl;
import com.speedment.runtime.field.internal.predicate.chars.CharBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharEqualPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharInPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.CharGetter;
import com.speedment.runtime.field.method.CharSetter;
import com.speedment.runtime.field.method.GetChar;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public final class CharFieldImpl<ENTITY, D>
implements CharField<ENTITY, D> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetChar<ENTITY, D> getter;
    private final CharSetter<ENTITY> setter;
    private final TypeMapper<D, Character> typeMapper;
    private final boolean unique;

    public CharFieldImpl(ColumnIdentifier<ENTITY> identifier, CharGetter<ENTITY> getter, CharSetter<ENTITY> setter, TypeMapper<D, Character> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetCharImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public CharSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetChar<ENTITY, D> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, Character> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public CharFieldComparator<ENTITY, D> comparator() {
        return new CharFieldComparatorImpl(this);
    }

    public CharFieldComparator<ENTITY, D> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    public CharFieldComparator<ENTITY, D> comparatorNullFieldsLast() {
        return this.comparator();
    }

    @Override
    public FieldPredicate<ENTITY> equal(Character value) {
        return new CharEqualPredicate(this, value.charValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Character value) {
        return new CharGreaterThanPredicate(this, value.charValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Character value) {
        return new CharGreaterOrEqualPredicate(this, value.charValue());
    }

    @Override
    public FieldPredicate<ENTITY> between(Character start, Character end, Inclusion inclusion) {
        return new CharBetweenPredicate(this, start.charValue(), end.charValue(), inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Character> values) {
        return new CharInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public Predicate<ENTITY> notEqual(Character value) {
        return new CharNotEqualPredicate(this, value.charValue());
    }

    @Override
    public Predicate<ENTITY> lessOrEqual(Character value) {
        return new CharLessOrEqualPredicate(this, value.charValue());
    }

    @Override
    public Predicate<ENTITY> lessThan(Character value) {
        return new CharLessThanPredicate(this, value.charValue());
    }

    @Override
    public Predicate<ENTITY> notBetween(Character start, Character end, Inclusion inclusion) {
        return new CharNotBetweenPredicate(this, start.charValue(), end.charValue(), inclusion);
    }

    @Override
    public Predicate<ENTITY> notIn(Collection<Character> values) {
        return new CharNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }
}

