/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.DoubleField;
import com.speedment.runtime.field.internal.comparator.DoubleFieldComparator;
import com.speedment.runtime.field.internal.comparator.DoubleFieldComparatorImpl;
import com.speedment.runtime.field.internal.method.GetDoubleImpl;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleEqualPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleInPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.DoubleGetter;
import com.speedment.runtime.field.method.DoubleSetter;
import com.speedment.runtime.field.method.GetDouble;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public final class DoubleFieldImpl<ENTITY, D>
implements DoubleField<ENTITY, D> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetDouble<ENTITY, D> getter;
    private final DoubleSetter<ENTITY> setter;
    private final TypeMapper<D, Double> typeMapper;
    private final boolean unique;

    public DoubleFieldImpl(ColumnIdentifier<ENTITY> identifier, DoubleGetter<ENTITY> getter, DoubleSetter<ENTITY> setter, TypeMapper<D, Double> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetDoubleImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public DoubleSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetDouble<ENTITY, D> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, Double> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public DoubleFieldComparator<ENTITY, D> comparator() {
        return new DoubleFieldComparatorImpl(this);
    }

    public DoubleFieldComparator<ENTITY, D> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    public DoubleFieldComparator<ENTITY, D> comparatorNullFieldsLast() {
        return this.comparator();
    }

    @Override
    public FieldPredicate<ENTITY> equal(Double value) {
        return new DoubleEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Double value) {
        return new DoubleGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Double value) {
        return new DoubleGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Double start, Double end, Inclusion inclusion) {
        return new DoubleBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Double> values) {
        return new DoubleInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public Predicate<ENTITY> notEqual(Double value) {
        return new DoubleNotEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> lessOrEqual(Double value) {
        return new DoubleLessOrEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> lessThan(Double value) {
        return new DoubleLessThanPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> notBetween(Double start, Double end, Inclusion inclusion) {
        return new DoubleNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public Predicate<ENTITY> notIn(Collection<Double> values) {
        return new DoubleNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }
}

