/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.FloatField;
import com.speedment.runtime.field.internal.comparator.FloatFieldComparator;
import com.speedment.runtime.field.internal.comparator.FloatFieldComparatorImpl;
import com.speedment.runtime.field.internal.method.GetFloatImpl;
import com.speedment.runtime.field.internal.predicate.floats.FloatBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatEqualPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatInPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.FloatGetter;
import com.speedment.runtime.field.method.FloatSetter;
import com.speedment.runtime.field.method.GetFloat;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public final class FloatFieldImpl<ENTITY, D>
implements FloatField<ENTITY, D> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetFloat<ENTITY, D> getter;
    private final FloatSetter<ENTITY> setter;
    private final TypeMapper<D, Float> typeMapper;
    private final boolean unique;

    public FloatFieldImpl(ColumnIdentifier<ENTITY> identifier, FloatGetter<ENTITY> getter, FloatSetter<ENTITY> setter, TypeMapper<D, Float> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetFloatImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public FloatSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetFloat<ENTITY, D> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, Float> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public FloatFieldComparator<ENTITY, D> comparator() {
        return new FloatFieldComparatorImpl(this);
    }

    public FloatFieldComparator<ENTITY, D> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    public FloatFieldComparator<ENTITY, D> comparatorNullFieldsLast() {
        return this.comparator();
    }

    @Override
    public FieldPredicate<ENTITY> equal(Float value) {
        return new FloatEqualPredicate(this, value.floatValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Float value) {
        return new FloatGreaterThanPredicate(this, value.floatValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Float value) {
        return new FloatGreaterOrEqualPredicate(this, value.floatValue());
    }

    @Override
    public FieldPredicate<ENTITY> between(Float start, Float end, Inclusion inclusion) {
        return new FloatBetweenPredicate(this, start.floatValue(), end.floatValue(), inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Float> values) {
        return new FloatInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public Predicate<ENTITY> notEqual(Float value) {
        return new FloatNotEqualPredicate(this, value.floatValue());
    }

    @Override
    public Predicate<ENTITY> lessOrEqual(Float value) {
        return new FloatLessOrEqualPredicate(this, value.floatValue());
    }

    @Override
    public Predicate<ENTITY> lessThan(Float value) {
        return new FloatLessThanPredicate(this, value.floatValue());
    }

    @Override
    public Predicate<ENTITY> notBetween(Float start, Float end, Inclusion inclusion) {
        return new FloatNotBetweenPredicate(this, start.floatValue(), end.floatValue(), inclusion);
    }

    @Override
    public Predicate<ENTITY> notIn(Collection<Float> values) {
        return new FloatNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }
}

