/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.IntField;
import com.speedment.runtime.field.internal.comparator.IntFieldComparator;
import com.speedment.runtime.field.internal.comparator.IntFieldComparatorImpl;
import com.speedment.runtime.field.internal.method.GetIntImpl;
import com.speedment.runtime.field.internal.predicate.ints.IntBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntEqualPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntInPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.GetInt;
import com.speedment.runtime.field.method.IntGetter;
import com.speedment.runtime.field.method.IntSetter;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public final class IntFieldImpl<ENTITY, D>
implements IntField<ENTITY, D> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetInt<ENTITY, D> getter;
    private final IntSetter<ENTITY> setter;
    private final TypeMapper<D, Integer> typeMapper;
    private final boolean unique;

    public IntFieldImpl(ColumnIdentifier<ENTITY> identifier, IntGetter<ENTITY> getter, IntSetter<ENTITY> setter, TypeMapper<D, Integer> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetIntImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public IntSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetInt<ENTITY, D> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, Integer> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public IntFieldComparator<ENTITY, D> comparator() {
        return new IntFieldComparatorImpl(this);
    }

    public IntFieldComparator<ENTITY, D> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    public IntFieldComparator<ENTITY, D> comparatorNullFieldsLast() {
        return this.comparator();
    }

    @Override
    public FieldPredicate<ENTITY> equal(Integer value) {
        return new IntEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Integer value) {
        return new IntGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Integer value) {
        return new IntGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Integer start, Integer end, Inclusion inclusion) {
        return new IntBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Integer> values) {
        return new IntInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public Predicate<ENTITY> notEqual(Integer value) {
        return new IntNotEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> lessOrEqual(Integer value) {
        return new IntLessOrEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> lessThan(Integer value) {
        return new IntLessThanPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> notBetween(Integer start, Integer end, Inclusion inclusion) {
        return new IntNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public Predicate<ENTITY> notIn(Collection<Integer> values) {
        return new IntNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }
}

