/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.field.ShortField;
import com.speedment.runtime.field.ShortForeignKeyField;
import com.speedment.runtime.field.internal.comparator.ShortFieldComparator;
import com.speedment.runtime.field.internal.comparator.ShortFieldComparatorImpl;
import com.speedment.runtime.field.internal.method.BackwardFinderImpl;
import com.speedment.runtime.field.internal.method.FindFromShort;
import com.speedment.runtime.field.internal.method.GetShortImpl;
import com.speedment.runtime.field.internal.predicate.shorts.ShortBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortEqualPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortInPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.BackwardFinder;
import com.speedment.runtime.field.method.FindFrom;
import com.speedment.runtime.field.method.GetShort;
import com.speedment.runtime.field.method.ShortGetter;
import com.speedment.runtime.field.method.ShortSetter;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class ShortForeignKeyFieldImpl<ENTITY, D, FK_ENTITY>
implements ShortField<ENTITY, D>,
ShortForeignKeyField<ENTITY, D, FK_ENTITY> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetShort<ENTITY, D> getter;
    private final ShortSetter<ENTITY> setter;
    private final ShortField<FK_ENTITY, D> referenced;
    private final TypeMapper<D, Short> typeMapper;
    private final boolean unique;

    public ShortForeignKeyFieldImpl(ColumnIdentifier<ENTITY> identifier, ShortGetter<ENTITY> getter, ShortSetter<ENTITY> setter, ShortField<FK_ENTITY, D> referenced, TypeMapper<D, Short> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetShortImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.referenced = Objects.requireNonNull(referenced);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public ShortSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetShort<ENTITY, D> getter() {
        return this.getter;
    }

    public ShortField<FK_ENTITY, D> getReferencedField() {
        return this.referenced;
    }

    @Override
    public BackwardFinder<FK_ENTITY, ENTITY> backwardFinder(TableIdentifier<ENTITY> identifier, Supplier<Stream<ENTITY>> streamSupplier) {
        return new BackwardFinderImpl(this, identifier, streamSupplier);
    }

    @Override
    public FindFrom<ENTITY, FK_ENTITY> finder(TableIdentifier<FK_ENTITY> identifier, Supplier<Stream<FK_ENTITY>> streamSupplier) {
        return new FindFromShort(this, this.referenced, identifier, streamSupplier);
    }

    @Override
    public TypeMapper<D, Short> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public ShortFieldComparator<ENTITY, D> comparator() {
        return new ShortFieldComparatorImpl(this);
    }

    public ShortFieldComparator<ENTITY, D> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    public ShortFieldComparator<ENTITY, D> comparatorNullFieldsLast() {
        return this.comparator();
    }

    @Override
    public FieldPredicate<ENTITY> equal(Short value) {
        return new ShortEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Short value) {
        return new ShortGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Short value) {
        return new ShortGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Short start, Short end, Inclusion inclusion) {
        return new ShortBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Short> values) {
        return new ShortInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public Predicate<ENTITY> notEqual(Short value) {
        return new ShortNotEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> lessOrEqual(Short value) {
        return new ShortLessOrEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> lessThan(Short value) {
        return new ShortLessThanPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> notBetween(Short start, Short end, Inclusion inclusion) {
        return new ShortNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public Predicate<ENTITY> notIn(Collection<Short> values) {
        return new ShortNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }
}

