/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.StringField;
import com.speedment.runtime.field.comparator.FieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.ReferenceFieldComparatorImpl;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceEqualPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceInPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceIsNullPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceNotInPredicate;
import com.speedment.runtime.field.internal.predicate.string.StringContainsIgnoreCasePredicate;
import com.speedment.runtime.field.internal.predicate.string.StringContainsPredicate;
import com.speedment.runtime.field.internal.predicate.string.StringEndsWithIgnoreCasePredicate;
import com.speedment.runtime.field.internal.predicate.string.StringEndsWithPredicate;
import com.speedment.runtime.field.internal.predicate.string.StringEqualIgnoreCasePredicate;
import com.speedment.runtime.field.internal.predicate.string.StringIsEmptyPredicate;
import com.speedment.runtime.field.internal.predicate.string.StringStartsWithIgnoreCasePredicate;
import com.speedment.runtime.field.internal.predicate.string.StringStartsWithPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.ReferenceGetter;
import com.speedment.runtime.field.method.ReferenceSetter;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public final class StringFieldImpl<ENTITY, D>
implements StringField<ENTITY, D> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final ReferenceGetter<ENTITY, String> getter;
    private final ReferenceSetter<ENTITY, String> setter;
    private final TypeMapper<D, String> typeMapper;
    private final boolean unique;

    public StringFieldImpl(ColumnIdentifier<ENTITY> identifier, ReferenceGetter<ENTITY, String> getter, ReferenceSetter<ENTITY, String> setter, TypeMapper<D, String> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = Objects.requireNonNull(getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public ReferenceSetter<ENTITY, String> setter() {
        return this.setter;
    }

    @Override
    public ReferenceGetter<ENTITY, String> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, String> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public FieldComparator<ENTITY> comparator() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.LAST);
    }

    @Override
    public FieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.FIRST);
    }

    @Override
    public FieldComparator<ENTITY> comparatorNullFieldsLast() {
        return this.comparator();
    }

    @Override
    public FieldPredicate<ENTITY> isNull() {
        return new ReferenceIsNullPredicate(this);
    }

    @Override
    public FieldPredicate<ENTITY> equal(String value) {
        Objects.requireNonNull(value);
        return new ReferenceEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> greaterThan(String value) {
        Objects.requireNonNull(value);
        return new ReferenceGreaterThanPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> greaterOrEqual(String value) {
        Objects.requireNonNull(value);
        return new ReferenceGreaterOrEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> between(String start, String end, Inclusion inclusion) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        Objects.requireNonNull(inclusion);
        return new ReferenceBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public Predicate<ENTITY> in(Collection<String> values) {
        Objects.requireNonNull(values);
        return new ReferenceInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public Predicate<ENTITY> notEqual(String value) {
        Objects.requireNonNull(value);
        return new ReferenceNotEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> lessThan(String value) {
        Objects.requireNonNull(value);
        return new ReferenceLessThanPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> lessOrEqual(String value) {
        Objects.requireNonNull(value);
        return new ReferenceLessOrEqualPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> notBetween(String start, String end, Inclusion inclusion) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        Objects.requireNonNull(inclusion);
        return new ReferenceNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public Predicate<ENTITY> notIn(Collection<String> values) {
        Objects.requireNonNull(values);
        return new ReferenceNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public Predicate<ENTITY> equalIgnoreCase(String value) {
        Objects.requireNonNull(value);
        return new StringEqualIgnoreCasePredicate(this, value.toLowerCase());
    }

    @Override
    public Predicate<ENTITY> startsWith(String value) {
        Objects.requireNonNull(value);
        return new StringStartsWithPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> endsWith(String value) {
        Objects.requireNonNull(value);
        return new StringEndsWithPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> contains(String value) {
        Objects.requireNonNull(value);
        return new StringContainsPredicate(this, value);
    }

    @Override
    public Predicate<ENTITY> isEmpty() {
        return new StringIsEmptyPredicate(this);
    }

    @Override
    public Predicate<ENTITY> startsWithIgnoreCase(String value) {
        Objects.requireNonNull(value);
        return new StringStartsWithIgnoreCasePredicate(this, value.toLowerCase());
    }

    @Override
    public Predicate<ENTITY> endsWithIgnoreCase(String value) {
        Objects.requireNonNull(value);
        return new StringEndsWithIgnoreCasePredicate(this, value.toLowerCase());
    }

    @Override
    public Predicate<ENTITY> containsIgnoreCase(String value) {
        Objects.requireNonNull(value);
        return new StringContainsIgnoreCasePredicate(this, value.toLowerCase());
    }

    public String toString() {
        return StringFieldImpl.class.getSimpleName() + "{" + this.identifier.getColumnName() + "}";
    }
}

