/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.comparator;

import com.speedment.common.invariant.NullUtil;
import com.speedment.runtime.field.comparator.FieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.AbstractFieldComparator;
import com.speedment.runtime.field.internal.comparator.ByteFieldComparator;
import com.speedment.runtime.field.trait.HasByteValue;
import java.util.Objects;

public final class ByteFieldComparatorImpl<ENTITY, D>
extends AbstractFieldComparator<ENTITY>
implements ByteFieldComparator<ENTITY, D> {
    private final HasByteValue<ENTITY, D> field;
    private final boolean reversed;

    public ByteFieldComparatorImpl(HasByteValue<ENTITY, D> field) {
        this(field, false);
    }

    ByteFieldComparatorImpl(HasByteValue<ENTITY, D> field, boolean reversed) {
        this.field = Objects.requireNonNull(field);
        this.reversed = reversed;
    }

    @Override
    public HasByteValue<ENTITY, D> getField() {
        return this.field;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.NONE;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public FieldComparator<ENTITY> reversed() {
        return new ByteFieldComparatorImpl<ENTITY, D>(this.field, !this.reversed);
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        NullUtil.requireNonNulls(first, second);
        byte a = this.field.getAsByte(first);
        byte b = this.field.getAsByte(second);
        return this.applyReversed(Byte.compare(a, b));
    }

    public int hashCode() {
        return (4049 + Objects.hashCode(this.field.identifier())) * 3109 + Boolean.hashCode(this.reversed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldComparator)) {
            return false;
        }
        FieldComparator casted = (FieldComparator)obj;
        return this.reversed == casted.isReversed() && Objects.equals(this.field.identifier(), casted.getField().identifier());
    }

    public String toString() {
        return "(order by " + this.field.identifier() + " " + (this.reversed ? "descending" : "ascending") + ")";
    }

    private int applyReversed(int compare) {
        if (compare == 0) {
            return 0;
        }
        if (this.reversed) {
            if (compare > 0) {
                return -1;
            }
            return 1;
        }
        if (compare > 0) {
            return 1;
        }
        return -1;
    }
}

