/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.method;

import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.field.Field;
import com.speedment.runtime.field.method.BackwardFinder;
import com.speedment.runtime.field.trait.HasComparableOperators;
import com.speedment.runtime.field.trait.HasFinder;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class BackwardFinderImpl<ENTITY, FK_ENTITY, T extends Comparable<? super T>, FIELD extends Field<FK_ENTITY> & HasComparableOperators<FK_ENTITY, T>>
implements BackwardFinder<ENTITY, FK_ENTITY> {
    private final FIELD target;
    private final TableIdentifier<FK_ENTITY> identifier;
    private final Supplier<Stream<FK_ENTITY>> streamSupplier;

    public BackwardFinderImpl(FIELD target, TableIdentifier<FK_ENTITY> identifier, Supplier<Stream<FK_ENTITY>> streamSupplier) {
        this.target = (Field)Objects.requireNonNull(target);
        this.identifier = Objects.requireNonNull(identifier);
        this.streamSupplier = Objects.requireNonNull(streamSupplier);
    }

    public final FIELD getField() {
        return this.target;
    }

    @Override
    public final TableIdentifier<FK_ENTITY> getTableIdentifier() {
        return this.identifier;
    }

    @Override
    public Stream<FK_ENTITY> apply(ENTITY entity) {
        Comparable value = (Comparable)((HasFinder)this.getField()).getReferencedField().getter().apply(entity);
        if (value == null) {
            return null;
        }
        return this.streamSupplier.get().filter(((HasComparableOperators)this.getField()).equal(value));
    }
}

