/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.method;

import com.speedment.runtime.field.method.SetToFloat;
import com.speedment.runtime.field.trait.HasFloatValue;
import java.util.Objects;

public final class SetToFloatImpl<ENTITY, D>
implements SetToFloat<ENTITY, D> {
    private final HasFloatValue<ENTITY, D> field;
    private final float newValue;

    public SetToFloatImpl(HasFloatValue<ENTITY, D> field, float newValue) {
        this.field = Objects.requireNonNull(field);
        this.newValue = Objects.requireNonNull(Float.valueOf(newValue)).floatValue();
    }

    @Override
    public HasFloatValue<ENTITY, D> getField() {
        return this.field;
    }

    @Override
    public float getValue() {
        return this.newValue;
    }

    @Override
    public ENTITY apply(ENTITY entity) {
        return this.field.setter().setAsFloat(entity, this.newValue);
    }
}

