/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate;

import com.speedment.runtime.field.internal.predicate.AbstractPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.predicate.CombinedPredicate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractCombinedPredicate<ENTITY>
extends AbstractPredicate<ENTITY>
implements CombinedPredicate<ENTITY> {
    private final List<Predicate<? super ENTITY>> predicates;
    private final CombinedPredicate.Type type;

    private AbstractCombinedPredicate(CombinedPredicate.Type type, List<Predicate<? super ENTITY>> predicates) {
        this.type = Objects.requireNonNull(type);
        this.predicates = Objects.requireNonNull(predicates);
    }

    protected List<Predicate<? super ENTITY>> getPredicates() {
        return Collections.unmodifiableList(this.predicates);
    }

    @Override
    public Stream<Predicate<? super ENTITY>> stream() {
        return this.predicates.stream();
    }

    @Override
    public int size() {
        return this.predicates.size();
    }

    @Override
    public CombinedPredicate.Type getType() {
        return this.type;
    }

    @Override
    public abstract CombinedPredicate<ENTITY> and(Predicate<? super ENTITY> var1);

    @Override
    public abstract CombinedPredicate<ENTITY> or(Predicate<? super ENTITY> var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CombinedPredicate)) {
            return false;
        }
        CombinedPredicate that = (CombinedPredicate)o;
        Iterator<Predicate<ENTITY>> it = this.predicates.iterator();
        if (this.getType() != that.getType()) return false;
        if (!that.stream().allMatch(it.next()::equals)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.getPredicates().hashCode();
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    public String toString() {
        return "CombinedPredicate {type=" + this.type.name() + ", predicates=" + this.predicates + "}";
    }

    public static final class OrCombinedBasePredicate<ENTITY>
    extends AbstractCombinedPredicate<ENTITY> {
        public OrCombinedBasePredicate(List<Predicate<? super ENTITY>> predicates) {
            super(CombinedPredicate.Type.OR, predicates);
        }

        @Override
        public boolean test(ENTITY entity) {
            Objects.requireNonNull(entity);
            return this.stream().anyMatch(p -> p.test(entity));
        }

        @Override
        public CombinedPredicate<ENTITY> and(Predicate<? super ENTITY> other) {
            Objects.requireNonNull(other);
            return CombinedPredicate.and(this, other);
        }

        @Override
        public CombinedPredicate<ENTITY> or(Predicate<? super ENTITY> other) {
            Objects.requireNonNull(other);
            return new OrCombinedBasePredicate<ENTITY>(CollectionUtil.copyAndAdd(this.getPredicates(), other));
        }

        @Override
        public AndCombinedBasePredicate<ENTITY> negate() {
            return new AndCombinedBasePredicate(this.getPredicates().stream().map(p -> p).map(Predicate::negate).collect(Collectors.toList()));
        }
    }

    public static final class AndCombinedBasePredicate<ENTITY>
    extends AbstractCombinedPredicate<ENTITY> {
        public AndCombinedBasePredicate(List<Predicate<? super ENTITY>> predicates) {
            super(CombinedPredicate.Type.AND, predicates);
        }

        @Override
        public boolean test(ENTITY entity) {
            Objects.requireNonNull(entity);
            return this.stream().allMatch(p -> p.test(entity));
        }

        @Override
        public CombinedPredicate<ENTITY> and(Predicate<? super ENTITY> other) {
            Objects.requireNonNull(other);
            return new AndCombinedBasePredicate<ENTITY>(CollectionUtil.copyAndAdd(this.getPredicates(), other));
        }

        @Override
        public CombinedPredicate<ENTITY> or(Predicate<? super ENTITY> other) {
            Objects.requireNonNull(other);
            return CombinedPredicate.or(this, other);
        }

        @Override
        public CombinedPredicate<ENTITY> negate() {
            return new OrCombinedBasePredicate(this.getPredicates().stream().map(p -> p).map(Predicate::negate).collect(Collectors.toList()));
        }
    }
}

