/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.floats;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.BetweenPredicate;
import com.speedment.runtime.field.internal.predicate.floats.FloatBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.trait.HasFloatValue;
import java.util.Objects;

public final class FloatNotBetweenPredicate<ENTITY, D>
extends AbstractFieldPredicate<ENTITY, HasFloatValue<ENTITY, D>>
implements BetweenPredicate,
Tuple2<Float, Float> {
    private final float start;
    private final float end;
    private final Inclusion inclusion;

    public FloatNotBetweenPredicate(HasFloatValue<ENTITY, D> field, float start, float end, Inclusion inclusion) {
        super(PredicateType.NOT_BETWEEN, field, entity -> {
            float fieldValue = field.getAsFloat(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start >= fieldValue || end <= fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start >= fieldValue || end < fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start > fieldValue || end <= fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start > fieldValue || end < fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    public Float get0() {
        return Float.valueOf(this.start);
    }

    public Float get1() {
        return Float.valueOf(this.end);
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public FloatBetweenPredicate<ENTITY, D> negate() {
        return new FloatBetweenPredicate((HasFloatValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

