/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.ints;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.BetweenPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.trait.HasIntValue;
import java.util.Objects;

public final class IntNotBetweenPredicate<ENTITY, D>
extends AbstractFieldPredicate<ENTITY, HasIntValue<ENTITY, D>>
implements BetweenPredicate,
Tuple2<Integer, Integer> {
    private final int start;
    private final int end;
    private final Inclusion inclusion;

    public IntNotBetweenPredicate(HasIntValue<ENTITY, D> field, int start, int end, Inclusion inclusion) {
        super(PredicateType.NOT_BETWEEN, field, entity -> {
            int fieldValue = field.getAsInt(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start >= fieldValue || end <= fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start >= fieldValue || end < fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start > fieldValue || end <= fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start > fieldValue || end < fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    public Integer get0() {
        return this.start;
    }

    public Integer get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public IntBetweenPredicate<ENTITY, D> negate() {
        return new IntBetweenPredicate((HasIntValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

