/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.longs;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.BetweenPredicate;
import com.speedment.runtime.field.internal.predicate.longs.LongNotBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.trait.HasLongValue;
import java.util.Objects;

public final class LongBetweenPredicate<ENTITY, D>
extends AbstractFieldPredicate<ENTITY, HasLongValue<ENTITY, D>>
implements BetweenPredicate,
Tuple2<Long, Long> {
    private final long start;
    private final long end;
    private final Inclusion inclusion;

    public LongBetweenPredicate(HasLongValue<ENTITY, D> field, long start, long end, Inclusion inclusion) {
        super(PredicateType.BETWEEN, field, entity -> {
            long fieldValue = field.getAsLong(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start < fieldValue && end > fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start < fieldValue && end >= fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start <= fieldValue && end > fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start <= fieldValue && end >= fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    public Long get0() {
        return this.start;
    }

    public Long get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public LongNotBetweenPredicate<ENTITY, D> negate() {
        return new LongNotBetweenPredicate((HasLongValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

