/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.reference;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.BetweenPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceNotBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.trait.HasReferenceValue;
import java.util.Objects;

public final class ReferenceBetweenPredicate<ENTITY, D, V extends Comparable<? super V>>
extends AbstractFieldPredicate<ENTITY, HasReferenceValue<ENTITY, D, V>>
implements BetweenPredicate,
Tuple2<V, V> {
    private final V start;
    private final V end;
    private final Inclusion inclusion;

    public ReferenceBetweenPredicate(HasReferenceValue<ENTITY, D, V> referenceField, V start, V end, Inclusion inclusion) {
        super(PredicateType.BETWEEN, referenceField, entity -> {
            Comparable fieldValue = (Comparable)referenceField.get(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    if (fieldValue == null) {
                        return false;
                    }
                    if (start == null || end == null) {
                        return false;
                    }
                    return start.compareTo(fieldValue) < 0 && end.compareTo(fieldValue) > 0;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    if (fieldValue == null) {
                        return start != null && end == null;
                    }
                    if (start == null || end == null) {
                        return false;
                    }
                    return start.compareTo(fieldValue) < 0 && end.compareTo(fieldValue) >= 0;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    if (fieldValue == null) {
                        return start == null && end != null;
                    }
                    if (start == null || end == null) {
                        return false;
                    }
                    return start.compareTo(fieldValue) <= 0 && end.compareTo(fieldValue) > 0;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    if (fieldValue == null) {
                        return start == null || end == null;
                    }
                    if (start == null || end == null) {
                        return false;
                    }
                    return start.compareTo(fieldValue) <= 0 && end.compareTo(fieldValue) >= 0;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    public V get0() {
        return this.start;
    }

    public V get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public ReferenceNotBetweenPredicate<ENTITY, D, V> negate() {
        return new ReferenceNotBetweenPredicate((HasReferenceValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

