/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.shorts;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.BetweenPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.trait.HasShortValue;
import java.util.Objects;

public final class ShortNotBetweenPredicate<ENTITY, D>
extends AbstractFieldPredicate<ENTITY, HasShortValue<ENTITY, D>>
implements BetweenPredicate,
Tuple2<Short, Short> {
    private final short start;
    private final short end;
    private final Inclusion inclusion;

    public ShortNotBetweenPredicate(HasShortValue<ENTITY, D> field, short start, short end, Inclusion inclusion) {
        super(PredicateType.NOT_BETWEEN, field, entity -> {
            short fieldValue = field.getAsShort(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start >= fieldValue || end <= fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start >= fieldValue || end < fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start > fieldValue || end <= fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start > fieldValue || end < fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    public Short get0() {
        return this.start;
    }

    public Short get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public ShortBetweenPredicate<ENTITY, D> negate() {
        return new ShortBetweenPredicate((HasShortValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

