/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public final class Cast {
    public static <T> Optional<T> cast(Object object, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        if (object == null) {
            return Optional.empty();
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            T result = clazz.cast(object);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static <T> T castOrFail(Object object, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        if (object == null) {
            throw new NoSuchElementException("null is not an instance of " + clazz.getName());
        }
        return (T)Optional.of(object).filter(o -> clazz.isAssignableFrom(o.getClass())).map(clazz::cast).get();
    }

    private Cast() {
        throw new UnsupportedOperationException();
    }
}

