/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CollectionUtil {
    public static <T> Set<T> collectionToSet(Collection<T> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        switch (collection.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(collection.iterator().next());
            }
        }
        return new HashSet<T>(collection);
    }

    @SafeVarargs
    public static <T> List<T> copyAndAdd(List<T> original, T ... element) {
        switch (original.size() + element.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(original.isEmpty() ? element[0] : original.get(0));
            }
        }
        ArrayList<T> copy = new ArrayList<T>(original);
        Collections.addAll(copy, element);
        return Collections.unmodifiableList(copy);
    }

    private CollectionUtil() {
    }
}

