
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Ipam extends Ipam {

  private final String driver;
  private final ImmutableList<IpamConfig> config;

  private AutoValue_Ipam(
      String driver,
      ImmutableList<IpamConfig> config) {
    this.driver = driver;
    this.config = config;
  }

  @JsonProperty(value = "Driver")
  @Override
  public String driver() {
    return driver;
  }

  @JsonProperty(value = "Config")
  @Override
  public ImmutableList<IpamConfig> config() {
    return config;
  }

  @Override
  public String toString() {
    return "Ipam{"
        + "driver=" + driver + ", "
        + "config=" + config
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Ipam) {
      Ipam that = (Ipam) o;
      return (this.driver.equals(that.driver()))
           && (this.config.equals(that.config()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.driver.hashCode();
    h *= 1000003;
    h ^= this.config.hashCode();
    return h;
  }

  static final class Builder extends Ipam.Builder {
    private String driver;
    private ImmutableList<IpamConfig> config;
    Builder() {
    }
    Builder(Ipam source) {
      this.driver = source.driver();
      this.config = source.config();
    }
    @Override
    public Ipam.Builder driver(String driver) {
      this.driver = driver;
      return this;
    }
    @Override
    public Ipam.Builder config(List<IpamConfig> config) {
      this.config = ImmutableList.copyOf(config);
      return this;
    }
    @Override
    public Ipam build() {
      String missing = "";
      if (driver == null) {
        missing += " driver";
      }
      if (config == null) {
        missing += " config";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Ipam(
          this.driver,
          this.config);
    }
  }

}
