/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.plugin.dockerfile.AbstractDockerMojo;
import com.spotify.plugin.dockerfile.LoggingProgressHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="push", defaultPhase=LifecyclePhase.DEPLOY, requiresProject=true, threadSafe=true)
public class PushMojo
extends AbstractDockerMojo {
    @Parameter(property="dockerfile.repository")
    private String repository;
    @Parameter(property="dockerfile.tag")
    private String tag;
    @Parameter(property="dockerfile.push.skip", defaultValue="false")
    private boolean skipPush;

    @Override
    protected void execute(DockerClient dockerClient) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skipPush) {
            log.info((CharSequence)"Skipping execution because 'dockerfile.push.skip' is set");
            return;
        }
        if (this.repository == null) {
            this.repository = this.readMetadata(AbstractDockerMojo.Metadata.REPOSITORY);
        }
        if (this.tag == null) {
            this.tag = this.readMetadata(AbstractDockerMojo.Metadata.TAG);
        }
        if (this.tag == null) {
            this.tag = "latest";
        }
        if (this.repository == null) {
            throw new MojoExecutionException("Can't push image; image repository not known (specify dockerfile.repository parameter, or run the tag goal before)");
        }
        try {
            dockerClient.push(PushMojo.formatImageName(this.repository, this.tag), (ProgressHandler)LoggingProgressHandler.forLog(log, this.verbose));
        }
        catch (DockerException | InterruptedException e) {
            throw new MojoExecutionException("Could not push image", (Exception)e);
        }
    }
}

