/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.plugin.dockerfile.AbstractDockerMojo;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="tag", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class TagMojo
extends AbstractDockerMojo {
    @Parameter(property="dockerfile.repository", required=true)
    private String repository;
    @Parameter(property="dockerfile.tag", defaultValue="latest", required=true)
    private String tag;
    @Parameter(property="dockerfile.force", defaultValue="true", required=true)
    private boolean force;
    @Parameter(property="dockerfile.tag.skip", defaultValue="false")
    private boolean skipTag;

    @Override
    protected void execute(DockerClient dockerClient) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skipTag) {
            log.info((CharSequence)"Skipping execution because 'dockerfile.tag.skip' is set");
            return;
        }
        String imageId = this.readMetadata(AbstractDockerMojo.Metadata.IMAGE_ID);
        String imageName = TagMojo.formatImageName(this.repository, this.tag);
        String message = MessageFormat.format("Tagging image {0} as {1}", imageId, imageName);
        log.info((CharSequence)message);
        try {
            dockerClient.tag(imageId, imageName, this.force);
        }
        catch (DockerException | InterruptedException e) {
            throw new MojoExecutionException("Could not tag Docker image", (Exception)e);
        }
        this.writeImageInfo(this.repository, this.tag);
        this.writeMetadata(log);
    }
}

