/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.plugin.dockerfile.AbstractDockerMojo;
import com.spotify.plugin.dockerfile.LoggingProgressHandler;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class BuildMojo
extends AbstractDockerMojo {
    @Parameter(defaultValue="${project.basedir}", property="dockerfile.contextDirectory", required=true)
    private File contextDirectory;
    @Parameter(property="dockerfile.repository")
    private String repository;
    @Parameter(property="dockerfile.tag", defaultValue="latest")
    private String tag;
    @Parameter(property="dockerfile.build.skip", defaultValue="false")
    private boolean skipBuild;
    @Parameter(property="dockerfile.build.pullNewerImage", defaultValue="true")
    private boolean pullNewerImage;
    @Parameter(property="dockerfile.build.noCache", defaultValue="false")
    private boolean noCache;

    @Override
    public void execute(DockerClient dockerClient) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skipBuild) {
            log.info((CharSequence)"Skipping execution because 'dockerfile.build.skip' is set");
            return;
        }
        String imageId = BuildMojo.buildImage(dockerClient, log, this.verbose, this.contextDirectory, this.repository, this.tag, this.pullNewerImage, this.noCache);
        if (imageId == null) {
            log.warn((CharSequence)"Docker build was successful, but no image was built");
        } else {
            log.info((CharSequence)MessageFormat.format("Detected build of image with id {0}", imageId));
            this.writeMetadata(AbstractDockerMojo.Metadata.IMAGE_ID, imageId);
        }
        if (this.repository != null) {
            this.writeImageInfo(this.repository, this.tag);
        }
        this.writeMetadata(log);
        if (this.repository == null) {
            log.info((CharSequence)MessageFormat.format("Successfully built {0}", imageId));
        } else {
            log.info((CharSequence)MessageFormat.format("Successfully built {0}", BuildMojo.formatImageName(this.repository, this.tag)));
        }
    }

    @Nullable
    static String buildImage(@Nonnull DockerClient dockerClient, @Nonnull Log log, boolean verbose, @Nonnull File contextDirectory, @Nullable String repository, @Nonnull String tag, boolean pullNewerImage, boolean noCache) throws MojoExecutionException, MojoFailureException {
        log.info((CharSequence)MessageFormat.format("Building Docker context {0}", contextDirectory));
        if (!new File(contextDirectory, "Dockerfile").exists() && !new File(contextDirectory, "dockerfile").exists()) {
            log.error((CharSequence)("Missing Dockerfile in context directory: " + contextDirectory.getPath()));
            throw new MojoFailureException("Missing Dockerfile in context directory: " + contextDirectory.getPath());
        }
        LoggingProgressHandler progressHandler = new LoggingProgressHandler(log, verbose);
        ArrayList<DockerClient.BuildParam> buildParameters = new ArrayList<DockerClient.BuildParam>();
        if (pullNewerImage) {
            buildParameters.add(DockerClient.BuildParam.pullNewerImage());
        }
        if (noCache) {
            buildParameters.add(DockerClient.BuildParam.noCache());
        }
        DockerClient.BuildParam[] buildParametersArray = buildParameters.toArray(new DockerClient.BuildParam[buildParameters.size()]);
        log.info((CharSequence)"");
        try {
            if (repository != null) {
                String name = BuildMojo.formatImageName(repository, tag);
                log.info((CharSequence)MessageFormat.format("Image will be built as {0}", name));
                log.info((CharSequence)"");
                dockerClient.build(contextDirectory.toPath(), name, (ProgressHandler)progressHandler, buildParametersArray);
            } else {
                log.info((CharSequence)"Image will be built without a name");
                log.info((CharSequence)"");
                dockerClient.build(contextDirectory.toPath(), (ProgressHandler)progressHandler, buildParametersArray);
            }
        }
        catch (DockerException | IOException | InterruptedException e) {
            throw new MojoExecutionException("Could not build image", (Exception)e);
        }
        log.info((CharSequence)"");
        return progressHandler.builtImageId();
    }
}

