/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.Entries;
import com.swoval.files.TypedPath;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class TypedPaths {
    private TypedPaths() {
    }

    static Path expanded(TypedPath typedPath) {
        if (typedPath instanceof TypedPathImpl) {
            return ((TypedPathImpl)typedPath).expanded();
        }
        try {
            return typedPath.isSymbolicLink() ? typedPath.getPath().toRealPath(new LinkOption[0]) : typedPath.getPath();
        }
        catch (IOException iOException) {
            return typedPath.getPath();
        }
    }

    static TypedPath getDelegate(Path path, final TypedPath typedPath) {
        return new TypedPathImpl(path){

            @Override
            public boolean exists() {
                return typedPath.exists();
            }

            @Override
            public boolean isDirectory() {
                return typedPath.isDirectory();
            }

            @Override
            public boolean isFile() {
                return typedPath.isFile();
            }

            @Override
            public boolean isSymbolicLink() {
                return typedPath.isSymbolicLink();
            }
        };
    }

    public static TypedPath get(Path path) {
        try {
            return TypedPaths.get(path, Entries.getKind(path));
        }
        catch (IOException iOException) {
            return TypedPaths.get(path, 16);
        }
    }

    static int getKind(TypedPath typedPath) {
        return (typedPath.exists() ? 0 : 16) | (typedPath.isDirectory() ? 1 : 0) | (typedPath.isFile() ? 2 : 0) | (typedPath.isSymbolicLink() ? 4 : 0);
    }

    static TypedPath get(Path path, final int n) {
        return new TypedPathImpl(path.isAbsolute() ? path : path.toAbsolutePath()){

            @Override
            public boolean exists() {
                return (n & 0x10) == 0;
            }

            @Override
            public boolean isDirectory() {
                return (n & 1) != 0;
            }

            @Override
            public boolean isFile() {
                return (n & 2) != 0;
            }

            @Override
            public boolean isSymbolicLink() {
                return (n & 4) != 0;
            }
        };
    }

    private static abstract class TypedPathImpl
    implements TypedPath {
        private final Path path;
        private Path realPath;

        TypedPathImpl(Path path) {
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Path expanded() {
            Path path = this.path;
            synchronized (path) {
                if (this.realPath == null) {
                    try {
                        this.realPath = this.isSymbolicLink() ? this.path.toRealPath(new LinkOption[0]) : this.path;
                        return this.realPath;
                    }
                    catch (IOException iOException) {
                        return this.path;
                    }
                }
                return this.realPath;
            }
        }

        public String toString() {
            return "TypedPath(path: " + this.path + ", exists: " + this.exists() + ", isFile: " + this.isFile() + ", isDirectory: " + this.isDirectory() + ", isSymbolicLink: " + this.isSymbolicLink() + ")";
        }

        public boolean equals(Object object) {
            return object instanceof TypedPath && ((TypedPath)object).getPath().equals(this.getPath());
        }

        public int hashCode() {
            return this.getPath().hashCode();
        }
    }
}

