/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.business;

import com.tencent.common.Configure;
import com.tencent.common.Log;
import com.tencent.common.Signature;
import com.tencent.common.Util;
import com.tencent.common.report.ReporterFactory;
import com.tencent.common.report.protocol.ReportReqData;
import com.tencent.common.report.service.ReportService;
import com.tencent.protocol.pay_protocol.ScanPayReqData;
import com.tencent.protocol.pay_protocol.ScanPayResData;
import com.tencent.protocol.pay_query_protocol.ScanPayQueryReqData;
import com.tencent.protocol.pay_query_protocol.ScanPayQueryResData;
import com.tencent.protocol.reverse_protocol.ReverseReqData;
import com.tencent.protocol.reverse_protocol.ReverseResData;
import com.tencent.service.ReverseService;
import com.tencent.service.ScanPayQueryService;
import com.tencent.service.ScanPayService;
import org.slf4j.LoggerFactory;

public class ScanPayBusiness {
    private static Log log = new Log(LoggerFactory.getLogger(ScanPayBusiness.class));
    private int waitingTimeBeforePayQueryServiceInvoked = 5000;
    private int payQueryLoopInvokedCount = 3;
    private int waitingTimeBeforeReverseServiceInvoked = 5000;
    private ScanPayService scanPayService = new ScanPayService();
    private ScanPayQueryService scanPayQueryService = new ScanPayQueryService();
    private ReverseService reverseService = new ReverseService();
    private boolean needRecallReverse = false;

    public void run(ScanPayReqData scanPayReqData, ResultListener resultListener) throws Exception {
        String outTradeNo = scanPayReqData.getOut_trade_no();
        long costTimeStart = System.currentTimeMillis();
        log.i("\u652f\u4ed8API\u8fd4\u56de\u7684\u6570\u636e\u5982\u4e0b\uff1a");
        String payServiceResponseString = this.scanPayService.request(scanPayReqData);
        long costTimeEnd = System.currentTimeMillis();
        long totalTimeCost = costTimeEnd - costTimeStart;
        log.i("api\u8bf7\u6c42\u603b\u8017\u65f6\uff1a" + totalTimeCost + "ms");
        log.i(payServiceResponseString);
        ScanPayResData scanPayResData = (ScanPayResData)Util.getObjectFromXML(payServiceResponseString, ScanPayResData.class);
        ReportReqData reportReqData = new ReportReqData(scanPayReqData.getDevice_info(), Configure.PAY_API, (int)totalTimeCost, scanPayResData.getReturn_code(), scanPayResData.getReturn_msg(), scanPayResData.getResult_code(), scanPayResData.getErr_code(), scanPayResData.getErr_code_des(), scanPayResData.getOut_trade_no(), scanPayReqData.getSpbill_create_ip());
        if (Configure.isUseThreadToDoReport()) {
            ReporterFactory.getReporter(reportReqData).run();
            long timeAfterReport = System.currentTimeMillis();
            log.i("pay+report\u603b\u8017\u65f6\uff08\u5f02\u6b65\u65b9\u5f0f\u4e0a\u62a5\uff09\uff1a" + (timeAfterReport - costTimeStart) + "ms");
        } else {
            ReportService.request(reportReqData);
            long timeAfterReport = System.currentTimeMillis();
            log.i("pay+report\u603b\u8017\u65f6\uff08\u540c\u6b65\u65b9\u5f0f\u4e0a\u62a5\uff09\uff1a" + (timeAfterReport - costTimeStart) + "ms");
        }
        if (scanPayResData == null || scanPayResData.getReturn_code() == null) {
            log.e("\u3010\u652f\u4ed8\u5931\u8d25\u3011\u652f\u4ed8\u8bf7\u6c42\u903b\u8f91\u9519\u8bef\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u6d4b\u4f20\u8fc7\u53bb\u7684\u6bcf\u4e00\u4e2a\u53c2\u6570\u662f\u5426\u5408\u6cd5\uff0c\u6216\u662f\u770bAPI\u80fd\u5426\u88ab\u6b63\u5e38\u8bbf\u95ee");
            resultListener.onFailByReturnCodeError(scanPayResData);
            return;
        }
        if (scanPayResData.getReturn_code().equals("FAIL")) {
            log.e("\u3010\u652f\u4ed8\u5931\u8d25\u3011\u652f\u4ed8API\u7cfb\u7edf\u8fd4\u56de\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bPost\u7ed9API\u7684\u6570\u636e\u662f\u5426\u89c4\u8303\u5408\u6cd5");
            resultListener.onFailByReturnCodeFail(scanPayResData);
            return;
        }
        log.i("\u652f\u4ed8API\u7cfb\u7edf\u6210\u529f\u8fd4\u56de\u6570\u636e");
        if (!Signature.checkIsSignValidFromResponseString(payServiceResponseString)) {
            log.e("\u3010\u652f\u4ed8\u5931\u8d25\u3011\u652f\u4ed8\u8bf7\u6c42API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u6709\u53ef\u80fd\u6570\u636e\u88ab\u7be1\u6539\u4e86");
            resultListener.onFailBySignInvalid(scanPayResData);
            return;
        }
        String errorCode = scanPayResData.getErr_code();
        String errorCodeDes = scanPayResData.getErr_code_des();
        if (scanPayResData.getResult_code().equals("SUCCESS")) {
            log.i("\u3010\u4e00\u6b21\u6027\u652f\u4ed8\u6210\u529f\u3011");
            resultListener.onSuccess(scanPayResData);
        } else {
            log.i("\u4e1a\u52a1\u8fd4\u56de\u5931\u8d25");
            log.i("err_code:" + errorCode);
            log.i("err_code_des:" + errorCodeDes);
            if (errorCode.equals("AUTHCODEEXPIRE") || errorCode.equals("AUTH_CODE_INVALID") || errorCode.equals("NOTENOUGH")) {
                this.doReverseLoop(outTradeNo);
                if (errorCode.equals("AUTHCODEEXPIRE")) {
                    log.w("\u3010\u652f\u4ed8\u6263\u6b3e\u660e\u786e\u5931\u8d25\u3011\u539f\u56e0\u662f\uff1a" + errorCodeDes);
                    resultListener.onFailByAuthCodeExpire(scanPayResData);
                } else if (errorCode.equals("AUTH_CODE_INVALID")) {
                    log.w("\u3010\u652f\u4ed8\u6263\u6b3e\u660e\u786e\u5931\u8d25\u3011\u539f\u56e0\u662f\uff1a" + errorCodeDes);
                    resultListener.onFailByAuthCodeInvalid(scanPayResData);
                } else if (errorCode.equals("NOTENOUGH")) {
                    log.w("\u3010\u652f\u4ed8\u6263\u6b3e\u660e\u786e\u5931\u8d25\u3011\u539f\u56e0\u662f\uff1a" + errorCodeDes);
                    resultListener.onFailByMoneyNotEnough(scanPayResData);
                }
            } else if (errorCode.equals("USERPAYING")) {
                if (this.doPayQueryLoop(this.payQueryLoopInvokedCount, outTradeNo)) {
                    log.i("\u3010\u9700\u8981\u7528\u6237\u8f93\u5165\u5bc6\u7801\u3001\u67e5\u8be2\u5230\u652f\u4ed8\u6210\u529f\u3011");
                    resultListener.onSuccess(scanPayResData);
                } else {
                    log.i("\u3010\u9700\u8981\u7528\u6237\u8f93\u5165\u5bc6\u7801\u3001\u5728\u4e00\u5b9a\u65f6\u95f4\u5185\u6ca1\u6709\u67e5\u8be2\u5230\u652f\u4ed8\u6210\u529f\u3001\u8d70\u64a4\u9500\u6d41\u7a0b\u3011");
                    this.doReverseLoop(outTradeNo);
                    resultListener.onFail(scanPayResData);
                }
            } else if (this.doPayQueryLoop(this.payQueryLoopInvokedCount, outTradeNo)) {
                log.i("\u3010\u652f\u4ed8\u6263\u6b3e\u672a\u77e5\u5931\u8d25\u3001\u67e5\u8be2\u5230\u652f\u4ed8\u6210\u529f\u3011");
                resultListener.onSuccess(scanPayResData);
            } else {
                log.i("\u3010\u652f\u4ed8\u6263\u6b3e\u672a\u77e5\u5931\u8d25\u3001\u5728\u4e00\u5b9a\u65f6\u95f4\u5185\u6ca1\u6709\u67e5\u8be2\u5230\u652f\u4ed8\u6210\u529f\u3001\u8d70\u64a4\u9500\u6d41\u7a0b\u3011");
                this.doReverseLoop(outTradeNo);
                resultListener.onFail(scanPayResData);
            }
        }
    }

    private boolean doOnePayQuery(String outTradeNo) throws Exception {
        Thread.sleep(this.waitingTimeBeforePayQueryServiceInvoked);
        ScanPayQueryReqData scanPayQueryReqData = new ScanPayQueryReqData("", outTradeNo);
        String payQueryServiceResponseString = this.scanPayQueryService.request(scanPayQueryReqData);
        log.i("\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2API\u8fd4\u56de\u7684\u6570\u636e\u5982\u4e0b\uff1a");
        log.i(payQueryServiceResponseString);
        ScanPayQueryResData scanPayQueryResData = (ScanPayQueryResData)Util.getObjectFromXML(payQueryServiceResponseString, ScanPayQueryResData.class);
        if (scanPayQueryResData == null || scanPayQueryResData.getReturn_code() == null) {
            log.i("\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\u8bf7\u6c42\u903b\u8f91\u9519\u8bef\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u6d4b\u4f20\u8fc7\u53bb\u7684\u6bcf\u4e00\u4e2a\u53c2\u6570\u662f\u5426\u5408\u6cd5");
            return false;
        }
        if (scanPayQueryResData.getReturn_code().equals("FAIL")) {
            log.i("\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2API\u7cfb\u7edf\u8fd4\u56de\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + scanPayQueryResData.getReturn_msg());
            return false;
        }
        if (scanPayQueryResData.getResult_code().equals("SUCCESS")) {
            if (scanPayQueryResData.getTrade_state().equals("SUCCESS")) {
                log.i("\u67e5\u8be2\u5230\u8ba2\u5355\u652f\u4ed8\u6210\u529f");
                return true;
            }
            log.i("\u67e5\u8be2\u5230\u8ba2\u5355\u652f\u4ed8\u4e0d\u6210\u529f");
            return false;
        }
        log.i("\u67e5\u8be2\u51fa\u9519\uff0c\u9519\u8bef\u7801\uff1a" + scanPayQueryResData.getErr_code() + "     \u9519\u8bef\u4fe1\u606f\uff1a" + scanPayQueryResData.getErr_code_des());
        return false;
    }

    private boolean doPayQueryLoop(int loopCount, String outTradeNo) throws Exception {
        if (loopCount == 0) {
            loopCount = 1;
        }
        int i = 0;
        while (i < loopCount) {
            if (this.doOnePayQuery(outTradeNo)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean doOneReverse(String outTradeNo) throws Exception {
        Thread.sleep(this.waitingTimeBeforeReverseServiceInvoked);
        ReverseReqData reverseReqData = new ReverseReqData("", outTradeNo);
        String reverseResponseString = this.reverseService.request(reverseReqData);
        log.i("\u64a4\u9500API\u8fd4\u56de\u7684\u6570\u636e\u5982\u4e0b\uff1a");
        log.i(reverseResponseString);
        ReverseResData reverseResData = (ReverseResData)Util.getObjectFromXML(reverseResponseString, ReverseResData.class);
        if (reverseResData == null) {
            log.i("\u652f\u4ed8\u8ba2\u5355\u64a4\u9500\u8bf7\u6c42\u903b\u8f91\u9519\u8bef\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u6d4b\u4f20\u8fc7\u53bb\u7684\u6bcf\u4e00\u4e2a\u53c2\u6570\u662f\u5426\u5408\u6cd5");
            return false;
        }
        if (reverseResData.getReturn_code().equals("FAIL")) {
            log.i("\u652f\u4ed8\u8ba2\u5355\u64a4\u9500API\u7cfb\u7edf\u8fd4\u56de\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + reverseResData.getReturn_msg());
            return false;
        }
        if (reverseResData.getResult_code().equals("FAIL")) {
            log.i("\u64a4\u9500\u51fa\u9519\uff0c\u9519\u8bef\u7801\uff1a" + reverseResData.getErr_code() + "     \u9519\u8bef\u4fe1\u606f\uff1a" + reverseResData.getErr_code_des());
            if (reverseResData.getRecall().equals("Y")) {
                this.needRecallReverse = true;
                return false;
            }
            this.needRecallReverse = false;
            return true;
        }
        log.i("\u652f\u4ed8\u8ba2\u5355\u64a4\u9500\u6210\u529f");
        return true;
    }

    private void doReverseLoop(String outTradeNo) throws Exception {
        this.needRecallReverse = true;
        while (this.needRecallReverse) {
            if (!this.doOneReverse(outTradeNo)) continue;
            return;
        }
    }

    public void setWaitingTimeBeforePayQueryServiceInvoked(int duration) {
        this.waitingTimeBeforePayQueryServiceInvoked = duration;
    }

    public void setPayQueryLoopInvokedCount(int count) {
        this.payQueryLoopInvokedCount = count;
    }

    public void setWaitingTimeBeforeReverseServiceInvoked(int duration) {
        this.waitingTimeBeforeReverseServiceInvoked = duration;
    }

    public void setScanPayService(ScanPayService service) {
        this.scanPayService = service;
    }

    public void setScanPayQueryService(ScanPayQueryService service) {
        this.scanPayQueryService = service;
    }

    public void setReverseService(ReverseService service) {
        this.reverseService = service;
    }

    public static interface ResultListener {
        public void onFailByReturnCodeError(ScanPayResData var1);

        public void onFailByReturnCodeFail(ScanPayResData var1);

        public void onFailBySignInvalid(ScanPayResData var1);

        public void onFailByAuthCodeExpire(ScanPayResData var1);

        public void onFailByAuthCodeInvalid(ScanPayResData var1);

        public void onFailByMoneyNotEnough(ScanPayResData var1);

        public void onFail(ScanPayResData var1);

        public void onSuccess(ScanPayResData var1);
    }
}

