/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.protocol.unified_protocol;

import com.tencent.common.Configure;
import com.tencent.common.RandomStringGenerator;
import com.tencent.common.Signature;
import com.tencent.protocol.unified_protocol.UnifiedResData;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class UnifiedOutData {
    private String appid = "";
    private String partnerid = "";
    private String prepayid = "";
    private String noncestr = "";
    private String sign = "";
    private String timestamp = "";

    public UnifiedOutData(UnifiedResData payResData) {
        this.setAppid(Configure.getAppid());
        this.setPartnerid(Configure.getMchid());
        this.setPrepayid(payResData.getPrepay_id());
        this.setNoncestr(RandomStringGenerator.getRandomStringByLength(32));
        this.setTimestamp(String.valueOf(System.currentTimeMillis() / 1000L));
        String sign = Signature.getSign(this.toMap());
        this.setSign(sign);
    }

    public String getPartnerid() {
        return this.partnerid;
    }

    public void setPartnerid(String partnerid) {
        this.partnerid = partnerid;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getNoncestr() {
        return this.noncestr;
    }

    public void setNoncestr(String noncestr) {
        this.noncestr = noncestr;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getPrepayid() {
        return this.prepayid;
    }

    public void setPrepayid(String prepayid) {
        this.prepayid = prepayid;
    }

    public String toJson() {
        StringBuffer buf = new StringBuffer("{");
        buf.append("\"return_code\":\"SUCCESS\"");
        buf.append(",").append("\"appid\":\"" + this.appid + "\"");
        buf.append(",").append("\"partnerid\":\"" + this.partnerid + "\"");
        buf.append(",").append("\"prepayid\":\"" + this.prepayid + "\"");
        buf.append(",").append("\"package\":\"Sign=WXPay\"");
        buf.append(",").append("\"noncestr\":\"" + this.noncestr + "\"");
        buf.append(",").append("\"timestamp\":\"" + this.timestamp + "\"");
        buf.append(",").append("\"sign\":\"" + this.sign + "\"");
        buf.append("}");
        return buf.toString();
    }

    public Map<String, Object> toMap() {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fieldArray = fields = this.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                Object obj = field.get(this);
                if (obj != null) {
                    map.put(field.getName(), obj);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        map.put("package", "Sign=WXPay");
        return map;
    }
}

